/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.GlobalProperties;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Hashtable;

public abstract class PacketHandler {
    public static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();

    public abstract boolean handle(IMQConnection var1, Packet var2) throws BrokerException;

    public void handleForbidden(IMQConnection iMQConnection, Packet packet, int n) throws BrokerException {
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        if (DEBUG) {
            this.logger.log(4, "handle forbidden: sending " + PacketType.getString(n));
        }
        packet2.setPacketType(n);
        packet2.setConsumerID(packet.getConsumerID());
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("JMQStatus", new Integer(403));
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
    }

    public void checkPermission(Packet packet, IMQConnection iMQConnection) throws AccessControlException, IOException, ClassNotFoundException, BrokerException {
        int n;
        int n2 = packet.getPacketType();
        String string = PacketType.mapOperation(n2);
        if (string == null) {
            return;
        }
        Hashtable hashtable = packet.getProperties();
        String string2 = (String)hashtable.get("JMQDestination");
        if (string2 == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() no JMQDestionation"));
        }
        Integer n3 = (Integer)hashtable.get("JMQDestType");
        if (n3 == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() no JMQDestType"));
        }
        int n4 = n3;
        String string3 = DestType.queueOrTopic(n4);
        if (string3 == null) {
            return;
        }
        Service service = iMQConnection.getService();
        if (!this.checkIsNonAdminDest(iMQConnection, service, n = service.getServiceType(), string2)) {
            return;
        }
        String string4 = string2;
        if (n2 == 34) {
            if (!this.checkIsAutoCreate(string2, n4)) {
                return;
            }
            DestinationUID destinationUID = DestinationUID.getUID(string2, DestType.isQueue(n4));
            if (destinationUID == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() can't get destination uid for " + string2));
            }
            Destination destination = Destination.getDestination(destinationUID);
            if (destination != null && !destination.isAutoCreated()) {
                return;
            }
            string4 = null;
        }
        this.checkPermission(iMQConnection, service, n, string, string4, string3, string2);
    }

    private boolean checkIsAutoCreate(String string, int n) {
        return !(DestType.isQueue(n) ? !GlobalProperties.getGlobalProperties().AUTOCREATE_QUEUE : DestType.isTopic(n) && !GlobalProperties.getGlobalProperties().AUTOCREATE_TOPIC);
    }

    private boolean checkIsNonAdminDest(IMQConnection iMQConnection, Service service, int n, String string) throws AccessControlException, BrokerException {
        if (!string.equals("__JMQAdmin")) {
            if (n == 1 && iMQConnection.getAccessController().isRestrictedAdmin()) {
                String string2 = Globals.getBrokerResources().getKString("B4102", string, service.getName());
                this.logger.log(16, string2);
                throw new AccessControlException(string2);
            }
            return true;
        }
        if (n == 1) {
            return false;
        }
        String string3 = "";
        Principal principal = iMQConnection.getAccessController().getAuthenticatedName();
        if (principal != null) {
            string3 = principal.getName();
        }
        Object[] objectArray = new String[]{string3, service.getName(), ServiceType.getServiceTypeString(n)};
        String string4 = Globals.getBrokerResources().getKString("B4076", objectArray);
        this.logger.log(16, string4);
        throw new AccessControlException(string4);
    }

    private void checkPermission(IMQConnection iMQConnection, Service service, int n, String string, String string2, String string3, String string4) throws AccessControlException {
        try {
            iMQConnection.getAccessController().checkDestinationPermission(service.getName(), ServiceType.getServiceTypeString(n), string, string2, string3);
        }
        catch (AccessControlException accessControlException) {
            if (string2 != null) {
                Object[] objectArray = new String[]{string, string3, string2};
                String string5 = Globals.getBrokerResources().getKString("B2041", objectArray);
                this.logger.log(16, string5 + " - " + accessControlException.getMessage(), accessControlException);
            } else {
                Object[] objectArray = new String[]{string, string3, string4};
                String string6 = Globals.getBrokerResources().getKString("B2042", objectArray);
                this.logger.log(16, string6 + " - " + accessControlException.getMessage(), accessControlException);
            }
            throw accessControlException;
        }
    }
}

