/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ResettableComponentMatcher;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.timing.Condition;
import org.fest.util.Strings;
import org.fest.util.Systems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentFoundCondition
extends Condition {
    private final ComponentFinder finder;
    private final ComponentMatcher matcher;
    private final Container root;
    private Component found;
    private final AtomicReference<ComponentLookupException> notFoundError = new AtomicReference();

    public ComponentFoundCondition(String description, ComponentFinder finder, ComponentMatcher matcher) {
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(String description, ComponentFinder finder, ComponentMatcher matcher, Container root) {
        this((Description)new BasicDescription(description), finder, matcher, root);
    }

    public ComponentFoundCondition(Description description, ComponentFinder finder, ComponentMatcher matcher) {
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(Description description, ComponentFinder finder, ComponentMatcher matcher, Container root) {
        super(description);
        this.finder = finder;
        this.matcher = matcher;
        this.root = root;
    }

    @Override
    public boolean test() {
        boolean matchFound = false;
        try {
            this.found = this.finder.find(this.root, this.matcher);
            matchFound = true;
        }
        catch (ComponentLookupException e) {
            this.notFoundError.set(e);
        }
        this.resetMatcher(matchFound);
        if (matchFound) {
            this.notFoundError.set(null);
        }
        return matchFound;
    }

    private void resetMatcher(boolean matchFound) {
        if (!(this.matcher instanceof ResettableComponentMatcher)) {
            return;
        }
        ((ResettableComponentMatcher)this.matcher).reset(matchFound);
    }

    @Override
    protected String descriptionAddendum() {
        ComponentLookupException error = this.notFoundError.get();
        if (error == null) {
            return "";
        }
        return Strings.concat((Object[])new Object[]{Systems.LINE_SEPARATOR, error.getMessage()});
    }

    public Component found() {
        return this.found;
    }

    public Collection<? extends Component> duplicatesFound() {
        ComponentLookupException error = this.notFoundError.get();
        if (error == null) {
            return Collections.emptyList();
        }
        return error.found();
    }
}

