/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import htsjdk.variant.variantcontext.Allele;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.gatk.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.pairhmm.JNILoglessPairHMM;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class VectorLoglessPairHMM
extends JNILoglessPairHMM {
    public static final long sse41Mask = 1L;
    public static final long sse42Mask = 2L;
    public static final long avxMask = 4L;
    public static final long enableAll = -1L;
    private static Boolean isVectorLoglessPairHMMLibraryLoaded = false;
    private HashMap<Haplotype, Integer> haplotypeToHaplotypeListIdxMap = new HashMap();
    private JNIHaplotypeDataHolderClass[] mHaplotypeDataArray;

    public native long jniGetMachineType();

    private native void jniInitializeClassFieldsAndMachineMask(Class<?> var1, Class<?> var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorLoglessPairHMM() {
        Boolean bl = isVectorLoglessPairHMMLibraryLoaded;
        synchronized (bl) {
            if (!isVectorLoglessPairHMMLibraryLoaded.booleanValue()) {
                try {
                    System.loadLibrary("VectorLoglessPairHMM");
                    logger.info((Object)"libVectorLoglessPairHMM found in JVM library path");
                }
                catch (UnsatisfiedLinkError ule) {
                    try {
                        logger.debug((Object)"libVectorLoglessPairHMM not found in JVM library path - trying to unpack from GATK jar file");
                        VectorLoglessPairHMM.loadLibraryFromJar("/org/broadinstitute/gatk/utils/pairhmm/libVectorLoglessPairHMM.so");
                        logger.info((Object)"libVectorLoglessPairHMM unpacked successfully from GATK jar file");
                    }
                    catch (IOException ioe) {
                        throw ule;
                    }
                }
                logger.info((Object)"Using vectorized implementation of PairHMM");
                isVectorLoglessPairHMMLibraryLoaded = true;
                this.jniInitializeClassFieldsAndMachineMask(JNIReadDataHolderClass.class, JNIHaplotypeDataHolderClass.class, -1L);
            }
        }
    }

    private native void jniInitializeHaplotypes(int var1, JNIHaplotypeDataHolderClass[] var2);

    @Override
    public HashMap<Haplotype, Integer> getHaplotypeToHaplotypeListIdxMap() {
        return this.haplotypeToHaplotypeListIdxMap;
    }

    @Override
    public void initialize(List<Haplotype> haplotypes, Map<String, List<GATKSAMRecord>> perSampleReadList, int readMaxLength, int haplotypeMaxLength) {
        int numHaplotypes = haplotypes.size();
        this.mHaplotypeDataArray = new JNIHaplotypeDataHolderClass[numHaplotypes];
        int idx = 0;
        this.haplotypeToHaplotypeListIdxMap.clear();
        for (Haplotype currHaplotype : haplotypes) {
            this.mHaplotypeDataArray[idx] = new JNIHaplotypeDataHolderClass();
            this.mHaplotypeDataArray[idx].haplotypeBases = currHaplotype.getBases();
            this.haplotypeToHaplotypeListIdxMap.put(currHaplotype, idx);
            ++idx;
        }
        this.jniInitializeHaplotypes(numHaplotypes, this.mHaplotypeDataArray);
    }

    private native void jniFinalizeRegion();

    @Override
    public void finalizeRegion() {
        this.jniFinalizeRegion();
    }

    private native void jniComputeLikelihoods(int var1, int var2, JNIReadDataHolderClass[] var3, JNIHaplotypeDataHolderClass[] var4, double[] var5, int var6);

    @Override
    public PerReadAlleleLikelihoodMap computeLikelihoods(List<GATKSAMRecord> reads, Map<Allele, Haplotype> alleleHaplotypeMap, Map<GATKSAMRecord, byte[]> GCPArrayMap) {
        if (doProfiling.booleanValue()) {
            this.startTime = System.nanoTime();
        }
        int readListSize = reads.size();
        int numHaplotypes = alleleHaplotypeMap.size();
        int numTestcases = readListSize * numHaplotypes;
        JNIReadDataHolderClass[] readDataArray = new JNIReadDataHolderClass[readListSize];
        int idx = 0;
        for (GATKSAMRecord read : reads) {
            readDataArray[idx] = new JNIReadDataHolderClass();
            readDataArray[idx].readBases = read.getReadBases();
            readDataArray[idx].readQuals = read.getBaseQualities();
            readDataArray[idx].insertionGOP = read.getBaseInsertionQualities();
            readDataArray[idx].deletionGOP = read.getBaseDeletionQualities();
            readDataArray[idx].overallGCP = GCPArrayMap.get(read);
            ++idx;
        }
        this.mLikelihoodArray = new double[readListSize * numHaplotypes];
        if (doProfiling.booleanValue()) {
            this.threadLocalSetupTimeDiff = System.nanoTime() - this.startTime;
        }
        this.jniComputeLikelihoods(readListSize, numHaplotypes, readDataArray, this.mHaplotypeDataArray, this.mLikelihoodArray, 12);
        PerReadAlleleLikelihoodMap likelihoodMap = new PerReadAlleleLikelihoodMap();
        idx = 0;
        int idxInsideHaplotypeList = 0;
        int readIdx = 0;
        for (GATKSAMRecord read : reads) {
            for (Map.Entry<Allele, Haplotype> currEntry : alleleHaplotypeMap.entrySet()) {
                idxInsideHaplotypeList = this.haplotypeToHaplotypeListIdxMap.get((Object)currEntry.getValue());
                likelihoodMap.add(read, currEntry.getKey(), (Double)this.mLikelihoodArray[readIdx + idxInsideHaplotypeList]);
                ++idx;
            }
            readIdx += numHaplotypes;
        }
        if (doProfiling.booleanValue()) {
            this.threadLocalPairHMMComputeTimeDiff = System.nanoTime() - this.startTime;
            pairHMMComputeTime += this.threadLocalPairHMMComputeTimeDiff;
            pairHMMSetupTime += this.threadLocalSetupTimeDiff;
        }
        return likelihoodMap;
    }

    public native void jniClose();

    @Override
    public void close() {
        if (doProfiling.booleanValue()) {
            System.out.println("Time spent in setup for JNI call : " + (double)pairHMMSetupTime * 1.0E-9);
        }
        super.close();
        this.jniClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws IOException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = VectorLoglessPairHMM.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        System.load(temp.getAbsolutePath());
    }

    protected class JNIHaplotypeDataHolderClass {
        public byte[] haplotypeBases = null;

        protected JNIHaplotypeDataHolderClass() {
        }
    }

    protected class JNIReadDataHolderClass {
        public byte[] readBases = null;
        public byte[] readQuals = null;
        public byte[] insertionGOP = null;
        public byte[] deletionGOP = null;
        public byte[] overallGCP = null;

        protected JNIReadDataHolderClass() {
        }
    }
}

