/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.collections;

import java.util.ArrayList;
import java.util.Collection;

public class ExpandingArrayList<E>
extends ArrayList<E> {
    public ExpandingArrayList() {
    }

    public ExpandingArrayList(Collection<? extends E> c) {
        super(c);
    }

    public ExpandingArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public E get(int index) throws IndexOutOfBoundsException {
        if (index < this.size()) {
            return super.get(index);
        }
        return null;
    }

    public E expandingGet(int index, E default_value) throws IndexOutOfBoundsException {
        this.maybeExpand(index, default_value);
        return super.get(index);
    }

    private void maybeExpand(int index, E value) {
        if (index >= this.size()) {
            this.ensureCapacity(index + 1);
            for (int i = this.size(); i <= index; ++i) {
                this.add(value);
            }
        }
    }

    @Override
    public E set(int index, E element) {
        this.maybeExpand(index, null);
        return super.set(index, element);
    }
}

