/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;

public class OracleTypeINTERVAL
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1394800182554224957L;
    static final int LDIINTYEARMONTH = 7;
    static final int LDIINTDAYSECOND = 10;
    static final int SIZE_INTERVAL_YM = 5;
    static final int SIZE_INTERVAL_DS = 11;
    byte typeId = 0;
    int scale = 0;
    int precision = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:19:15_PDT_2011";
    public static final boolean TRACE = false;

    protected OracleTypeINTERVAL() {
    }

    public OracleTypeINTERVAL(OracleConnection oracleConnection) {
    }

    @Override
    public int getTypeCode() {
        if (this.typeId == 7) {
            return -103;
        }
        if (this.typeId == 10) {
            return -104;
        }
        return 1111;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.typeId = tDSReader.readByte();
        this.precision = tDSReader.readByte();
        this.scale = tDSReader.readByte();
    }

    @Override
    public int getScale() throws SQLException {
        return this.scale;
    }

    @Override
    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.typeId = objectInputStream.readByte();
        this.precision = objectInputStream.readByte();
        this.scale = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.typeId);
        objectOutputStream.writeByte(this.precision);
        objectOutputStream.writeByte(this.scale);
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                if (byArray.length == 5) {
                    return new INTERVALYM(byArray);
                }
                if (byArray.length != 11) break;
                return new INTERVALDS(byArray);
            }
            case 2: {
                if (byArray.length == 5) {
                    return INTERVALYM.toString(byArray);
                }
                if (byArray.length != 11) break;
                return INTERVALDS.toString(byArray);
            }
            case 3: {
                return byArray;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return null;
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum datum = null;
        if (object != null) {
            if (object instanceof INTERVALYM || object instanceof INTERVALDS) {
                datum = (Datum)object;
            } else if (object instanceof String) {
                try {
                    datum = new INTERVALDS((String)object);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    datum = new INTERVALYM((String)object);
                }
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return datum;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
        sQLException.fillInStackTrace();
        throw sQLException;
    }
}

