/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.markduplicates.MarkDuplicatesWithMateCigarIterator;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;

@CommandLineProgramProperties(usage="Examines aligned records in the supplied SAM or BAM file to locate duplicate molecules. All records are then written to the output file with the duplicate records flagged.", usageShort="Examines aligned records in the supplied SAM or BAM file to locate duplicate molecules.", programGroup=SamOrBam.class)
public class MarkDuplicatesWithMateCigar
extends AbstractMarkDuplicatesCommandLineProgram {
    private final Log log = Log.getInstance(MarkDuplicatesWithMateCigar.class);
    @Option(doc="The minimum distance to buffer records to account for clipping on the 5' end of the records.Set this number to -1 to use twice the first read's read length (or 100, whichever is smaller).", optional=true)
    public int MINIMUM_DISTANCE = -1;
    @Option(doc="Skip record pairs with no mate cigar and include them in the output.")
    boolean SKIP_PAIRS_WITH_NO_MATE_CIGAR = true;
    @Option(doc="The block size for use in the coordinate-sorted record buffer.", optional=true)
    public int BLOCK_SIZE = 100000;
    private boolean warnedNullProgramRecords = false;
    private boolean warnedMissingProgramRecords = false;

    public static void main(String[] args) {
        new MarkDuplicatesWithMateCigar().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFilesAreReadable((List)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.METRICS_FILE);
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator = this.openInputs();
        SAMFileHeader header = headerAndIterator.header;
        SAMFileHeader outputHeader = header.clone();
        outputHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        for (String comment : this.COMMENT) {
            outputHeader.addComment(comment);
        }
        this.setPGIdsSeen(outputHeader);
        Map<String, String> chainedPgIds = this.getChainedPgIds(outputHeader);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outputHeader, true, this.OUTPUT);
        MarkDuplicatesWithMateCigarIterator iterator = new MarkDuplicatesWithMateCigarIterator(headerAndIterator.header, headerAndIterator.iterator, this.opticalDuplicateFinder, this.DUPLICATE_SCORING_STRATEGY, this.MINIMUM_DISTANCE, this.REMOVE_DUPLICATES, this.SKIP_PAIRS_WITH_NO_MATE_CIGAR, this.MAX_RECORDS_IN_RAM, this.BLOCK_SIZE, this.TMP_DIR);
        ProgressLogger progress = new ProgressLogger(this.log, 1000000, "Read");
        for (SAMRecord record : new IterableAdapter((Iterator)((Object)iterator))) {
            if (progress.record(record)) {
                iterator.logMemoryStats(this.log);
            }
            this.updateProgramRecord(record, chainedPgIds);
            out.addAlignment(record);
        }
        iterator.close();
        out.close();
        Histogram<Short> opticalDupesByLibraryId = iterator.getOpticalDupesByLibraryId();
        this.log.info(new Object[]{"Processed " + progress.getCount() + " records"});
        this.log.info(new Object[]{"Found " + iterator.getNumRecordsWithNoMateCigar() + " records with no mate cigar optional tag."});
        this.log.info(new Object[]{"Marking " + iterator.getNumDuplicates() + " records as duplicates."});
        this.log.info(new Object[]{"Found " + (long)opticalDupesByLibraryId.getSumOfValues() + " optical duplicate clusters."});
        this.finalizeAndWriteMetrics(iterator.getLibraryIdGenerator());
        return 0;
    }

    private void updateProgramRecord(SAMRecord record, Map<String, String> chainedPgIds) {
        if (this.PROGRAM_RECORD_ID != null) {
            String pgId = record.getStringAttribute(SAMTag.PG.name());
            if (null == pgId) {
                if (!this.warnedNullProgramRecords) {
                    this.warnedNullProgramRecords = true;
                    this.log.warn(new Object[]{"Encountered a record with no program record, program group chaining will not occur for this read: " + record});
                }
            } else if (!chainedPgIds.containsKey(pgId)) {
                if (!this.warnedMissingProgramRecords) {
                    this.warnedMissingProgramRecords = true;
                    this.log.warn(new Object[]{"Encountered a record with an intermediate program record, program group chaining will not occur for this read: " + record});
                }
            } else {
                record.setAttribute(SAMTag.PG.name(), (Object)chainedPgIds.get(pgId));
            }
        }
    }

    private void setPGIdsSeen(SAMFileHeader header) {
        HashSet<String> pgIdsSeenAsPrevious = new HashSet<String>();
        for (SAMProgramRecord samProgramRecord : header.getProgramRecords()) {
            String previousProgramGroupID = samProgramRecord.getPreviousProgramGroupId();
            if (null == previousProgramGroupID) continue;
            pgIdsSeenAsPrevious.add(previousProgramGroupID);
        }
        for (SAMProgramRecord samProgramRecord : header.getProgramRecords()) {
            String pgId = samProgramRecord.getId();
            if (pgIdsSeenAsPrevious.contains(pgId)) continue;
            this.pgIdsSeen.add(pgId);
        }
    }
}

