/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.NullOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContainerHeaderIO {
    public boolean readContainerHeader(Container c, InputStream is) throws IOException {
        byte[] peek = new byte[4];
        int ch = is.read();
        if (ch == -1) {
            return false;
        }
        peek[0] = (byte)ch;
        for (int i = 1; i < peek.length; ++i) {
            ch = is.read();
            if (ch == -1) {
                throw new RuntimeException("Incomplete or broken stream.");
            }
            peek[i] = (byte)ch;
        }
        c.containerByteSize = ByteBufferUtils.int32(peek);
        c.sequenceId = ByteBufferUtils.readUnsignedITF8(is);
        c.alignmentStart = ByteBufferUtils.readUnsignedITF8(is);
        c.alignmentSpan = ByteBufferUtils.readUnsignedITF8(is);
        c.nofRecords = ByteBufferUtils.readUnsignedITF8(is);
        c.globalRecordCounter = ByteBufferUtils.readUnsignedLTF8(is);
        c.bases = ByteBufferUtils.readUnsignedLTF8(is);
        c.blockCount = ByteBufferUtils.readUnsignedITF8(is);
        c.landmarks = ByteBufferUtils.array(is);
        return true;
    }

    public int writeContainerHeader(Container c, OutputStream os) throws IOException {
        int len = ByteBufferUtils.writeInt32(c.containerByteSize, os);
        len += ByteBufferUtils.writeUnsignedITF8(c.sequenceId, os);
        len += ByteBufferUtils.writeUnsignedITF8(c.alignmentStart, os);
        len += ByteBufferUtils.writeUnsignedITF8(c.alignmentSpan, os);
        len += ByteBufferUtils.writeUnsignedITF8(c.nofRecords, os);
        len += ByteBufferUtils.writeUnsignedLTF8(c.globalRecordCounter, os);
        len += ByteBufferUtils.writeUnsignedLTF8(c.bases, os);
        len += ByteBufferUtils.writeUnsignedITF8(c.blockCount, os);
        return len += ByteBufferUtils.write(c.landmarks, os);
    }

    public int sizeOfContainerHeader(Container c) throws IOException {
        NullOutputStream nos = new NullOutputStream();
        return this.writeContainerHeader(c, nos);
    }
}

