/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import htsjdk.samtools.cram.mask.PositionMask;
import htsjdk.samtools.cram.mask.ReadMaskFactory;
import htsjdk.samtools.cram.mask.ReadMaskFormatException;
import htsjdk.samtools.cram.mask.ReadMaskReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;

public class SingleLineMaskReader
implements Closeable,
ReadMaskReader {
    private final BufferedReader reader;
    private final ReadMaskFactory<String> readMaskFactory;

    public SingleLineMaskReader(BufferedReader reader, ReadMaskFactory<String> readMaskFactory) {
        this.reader = reader;
        this.readMaskFactory = readMaskFactory;
    }

    @Override
    public PositionMask readNextMask() throws IOException, ReadMaskFormatException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        return this.readMaskFactory.createMask(line);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

