/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.BitInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DefaultBitInputStream
extends DataInputStream
implements BitInputStream {
    private int nofBufferedBits = 0;
    private int byteBuffer = 0;
    private boolean endOfStream = false;
    private boolean throwEOF = false;
    private static final long[] masks = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L};
    private boolean byteAligned = false;

    public DefaultBitInputStream(InputStream in) {
        this(in, true);
    }

    public DefaultBitInputStream(InputStream in, boolean throwEOF) {
        super(in);
        this.throwEOF = throwEOF;
    }

    @Override
    public final boolean readBit() throws IOException {
        if (--this.nofBufferedBits >= 0) {
            return (this.byteBuffer >>> this.nofBufferedBits & 1) == 1;
        }
        this.nofBufferedBits = 7;
        this.byteBuffer = this.in.read();
        if (this.byteBuffer == -1) {
            this.endOfStream = true;
            if (this.throwEOF) {
                throw new EOFException("End of stream.");
            }
        }
        return (this.byteBuffer >>> 7 & 1) == 1;
    }

    @Override
    public final int readBits(int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        int x = 0;
        while (n > this.nofBufferedBits) {
            x |= DefaultBitInputStream.rightBits(this.nofBufferedBits, this.byteBuffer) << (n -= this.nofBufferedBits);
            this.byteBuffer = this.in.read();
            if (this.byteBuffer == -1) {
                this.endOfStream = true;
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        return x | DefaultBitInputStream.rightBits(n, this.byteBuffer >>> this.nofBufferedBits);
    }

    private static final int rightBits(int n, int x) {
        return x & (1 << n) - 1;
    }

    private static final long rightLongBits(int n, long x) {
        return x & (long)((1 << n) - 1);
    }

    private final void readNextByte() throws IOException {
        this.byteBuffer = this.in.read();
        if (this.byteBuffer == -1) {
            this.endOfStream = true;
            throw new EOFException("End of stream.");
        }
        this.nofBufferedBits = 8;
    }

    public final long readLongBits1(int len) throws IOException {
        if (len > 64) {
            throw new RuntimeException("More then 64 bits are requested in one read from bit stream.");
        }
        long result = 0L;
        long last = len - 1;
        for (long bi = 0L; bi <= last; ++bi) {
            boolean frag = this.readBit();
            if (!frag) continue;
            result |= 1L << (int)(last - bi);
        }
        return result;
    }

    @Override
    public final long readLongBits(int n) throws IOException {
        if (n > 64) {
            throw new RuntimeException("More then 64 bits are requested in one read from bit stream.");
        }
        if (n == 0) {
            return 0L;
        }
        long x = 0L;
        long byteBuffer = this.byteBuffer;
        if (this.nofBufferedBits == 0) {
            byteBuffer = this.in.read();
            if (byteBuffer == -1L) {
                this.endOfStream = true;
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        byteBuffer &= masks[this.nofBufferedBits];
        while (n > this.nofBufferedBits) {
            x |= byteBuffer << (n -= this.nofBufferedBits);
            byteBuffer = this.in.read();
            if (byteBuffer == -1L) {
                this.endOfStream = true;
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        this.byteBuffer = (int)(byteBuffer & masks[this.nofBufferedBits]);
        return x | byteBuffer >>> this.nofBufferedBits;
    }

    @Override
    public void reset() {
        this.nofBufferedBits = 0;
        this.byteBuffer = 0;
    }

    @Override
    public boolean endOfStream() throws IOException {
        return this.endOfStream;
    }

    public int getNofBufferedBits() {
        return this.nofBufferedBits;
    }

    @Override
    public boolean putBack(long b, int numBits) {
        return false;
    }

    @Override
    public void alignToByte() throws IOException {
        this.nofBufferedBits = 0;
        this.byteBuffer = 0;
        this.byteAligned = true;
    }

    @Override
    public int readAlignedBytes(byte[] array) throws IOException {
        this.readFully(array);
        return array.length * 8;
    }

    @Override
    public boolean ensureMarker(long marker, int nofBits) throws IOException {
        long actual = this.readBits(nofBits);
        return actual == marker;
    }
}

