/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffint;

import htsjdk.samtools.cram.encoding.huffint.HuffmanBitCode;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class HelperByte {
    TreeMap<Integer, HuffmanBitCode> codes;
    int[] values;
    int[] bitLengths;
    private TreeMap<Integer, SortedSet<Integer>> codebook;
    final HuffmanBitCode[] sortedCodes;
    final byte[] sortedValues;
    final int[] sortedValuesByBitCode;
    final int[] sortedBitLensByBitCode;
    final int[] bitCodeToValue;
    final HuffmanBitCode[] valueToCode;
    static Comparator<HuffmanBitCode> bitCodeComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode o1, HuffmanBitCode o2) {
            int result = o1.bitLentgh - o2.bitLentgh;
            if (result == 0) {
                return o1.bitCode - o2.bitCode;
            }
            return result;
        }
    };
    static Comparator<HuffmanBitCode> valueComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode o1, HuffmanBitCode o2) {
            return o1.value - o2.value;
        }
    };

    HelperByte(byte[] values, int[] bitLengths) {
        int i;
        this.values = new int[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.values[i2] = 0xFF & values[i2];
        }
        this.bitLengths = bitLengths;
        this.buildCodeBook();
        this.buildCodes();
        ArrayList<HuffmanBitCode> list = new ArrayList<HuffmanBitCode>(this.codes.size());
        list.addAll(this.codes.values());
        Collections.sort(list, bitCodeComparator);
        this.sortedCodes = list.toArray(new HuffmanBitCode[list.size()]);
        this.sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(this.sortedValues);
        this.sortedValuesByBitCode = new int[this.sortedCodes.length];
        this.sortedBitLensByBitCode = new int[this.sortedCodes.length];
        int maxBitCode = 0;
        for (i = 0; i < this.sortedCodes.length; ++i) {
            this.sortedValuesByBitCode[i] = this.sortedCodes[i].value;
            this.sortedBitLensByBitCode[i] = this.sortedCodes[i].bitLentgh;
            if (maxBitCode >= this.sortedCodes[i].bitCode) continue;
            maxBitCode = this.sortedCodes[i].bitCode;
        }
        this.bitCodeToValue = new int[maxBitCode + 1];
        Arrays.fill(this.bitCodeToValue, -1);
        for (i = 0; i < this.sortedCodes.length; ++i) {
            this.bitCodeToValue[this.sortedCodes[i].bitCode] = i;
        }
        this.valueToCode = new HuffmanBitCode[255];
        Arrays.fill(this.valueToCode, null);
        HuffmanBitCode[] arr$ = this.sortedCodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HuffmanBitCode code;
            this.valueToCode[code.value] = code = arr$[i$];
        }
    }

    private void buildCodeBook() {
        this.codebook = new TreeMap();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.codebook.containsKey(this.bitLengths[i])) {
                ((TreeSet)this.codebook.get(this.bitLengths[i])).add(this.values[i]);
                continue;
            }
            TreeSet<Integer> entry = new TreeSet<Integer>();
            entry.add(this.values[i]);
            this.codebook.put(this.bitLengths[i], entry);
        }
    }

    private void buildCodes() {
        this.codes = new TreeMap();
        Set<Integer> keySet = this.codebook.keySet();
        int codeLength = 0;
        int codeValue = -1;
        for (Integer key : keySet) {
            int iKey = Integer.parseInt(((Object)key).toString());
            TreeSet get = (TreeSet)this.codebook.get(key);
            for (Integer entry : get) {
                HuffmanBitCode code = new HuffmanBitCode();
                code.bitLentgh = iKey;
                code.value = entry;
                ++codeValue;
                int delta = iKey - codeLength;
                code.bitCode = codeValue <<= delta;
                codeLength += delta;
                if (HelperByte.NumberOfSetBits(codeValue) > iKey) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(entry, code);
            }
        }
    }

    final long write(BitOutputStream bos, byte value) throws IOException {
        HuffmanBitCode code = this.valueToCode[value];
        if (code.value != value) {
            throw new RuntimeException(String.format("Searching for %d but found %s.", value, code.toString()));
        }
        bos.write(code.bitCode, code.bitLentgh);
        return code.bitLentgh;
    }

    final byte read(BitInputStream bis) throws IOException {
        int prevLen = 0;
        int bits = 0;
        for (int i = 0; i < this.sortedCodes.length; ++i) {
            int len = this.sortedCodes[i].bitLentgh;
            bits <<= len - prevLen;
            prevLen = len;
            int index = this.bitCodeToValue[bits |= bis.readBits(len - prevLen)];
            if (index > -1 && this.sortedBitLensByBitCode[index] == len) {
                return (byte)(0xFF & this.sortedValuesByBitCode[index]);
            }
            for (int j = i; this.sortedCodes[j + 1].bitLentgh == len && j < this.sortedCodes.length; ++j) {
                ++i;
            }
        }
        throw new RuntimeException("Not found.");
    }

    private static int NumberOfSetBits(int i) {
        i -= i >> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >> 2 & 0x33333333);
        return (i + (i >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }
}

