/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class SubexpIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int k = 2;
    private boolean unaryBit = true;

    public SubexpIntegerCodec(int offset, int k) {
        this(offset, k, true);
    }

    public SubexpIntegerCodec(int offset, int k, boolean unaryBit) {
        this.offset = offset;
        this.k = k;
        this.unaryBit = unaryBit;
    }

    public SubexpIntegerCodec(int k) {
        this.k = k;
    }

    @Override
    public final Integer read(BitInputStream bis) throws IOException {
        int u = 0;
        while (bis.readBit() == this.unaryBit) {
            ++u;
        }
        int b = 0;
        int n = 0;
        if (u == 0) {
            b = this.k;
            n = bis.readBits(b);
        } else {
            b = u + this.k - 1;
            n = 1 << b | bis.readBits(b);
        }
        return n - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Integer value) throws IOException {
        if (value + this.offset < 0) {
            throw new IllegalArgumentException("Value is less then offset: " + value);
        }
        long newValue = value + this.offset;
        int b = 0;
        int u = 0;
        if (newValue < 1L << this.k) {
            b = this.k;
            u = 0;
        } else {
            b = (int)(Math.log(newValue) / Math.log(2.0));
            u = b - this.k + 1;
        }
        bos.write(this.unaryBit, (long)u);
        bos.write(!this.unaryBit);
        bos.write(newValue, b);
        return u + 1 + b;
    }

    @Override
    public final long numberOfBits(Integer value) {
        long newValue = value + this.offset;
        long b = 0L;
        long u = 0L;
        if (newValue < 1L << this.k) {
            b = this.k;
            u = 0L;
        } else {
            b = (long)Math.floor(Math.log(newValue) / Math.log(2.0));
            u = b - (long)this.k + 1L;
        }
        return u + 1L + b;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public boolean isUnaryBit() {
        return this.unaryBit;
    }

    public void setUnaryBit(boolean unaryBit) {
        this.unaryBit = unaryBit;
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

