/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReaderFactory;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContainerParser {
    private static Log log = Log.getInstance(ContainerParser.class);
    private SAMFileHeader samFileHeader;
    private Map<String, Long> nanoMap = new TreeMap<String, Long>();

    public ContainerParser(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> records) throws IllegalArgumentException, IllegalAccessException, IOException {
        long time1 = System.nanoTime();
        if (records == null) {
            records = new ArrayList(container.nofRecords);
        }
        for (Slice s : container.slices) {
            records.addAll(this.getRecords(s, container.h));
        }
        long time2 = System.nanoTime();
        container.parseTime = time2 - time1;
        if (log.isEnabled(Log.LogLevel.DEBUG)) {
            for (String key : this.nanoMap.keySet()) {
                log.debug(String.format("%s: %dms.", key, this.nanoMap.get(key) / 1000000L));
            }
        }
        return records;
    }

    public List<CramCompressionRecord> getRecords(Slice s, CompressionHeader h) throws IllegalArgumentException, IllegalAccessException, IOException {
        String seqName = "*";
        switch (s.sequenceId) {
            case -1: {
                break;
            }
            case -2: {
                break;
            }
            default: {
                SAMSequenceRecord sequence = this.samFileHeader.getSequence(s.sequenceId);
                seqName = sequence.getSequenceName();
            }
        }
        DataReaderFactory f = new DataReaderFactory();
        HashMap<Integer, InputStream> inputMap = new HashMap<Integer, InputStream>();
        for (Integer exId : s.external.keySet()) {
            inputMap.put(exId, new ByteArrayInputStream(s.external.get(exId).getRawContent()));
        }
        long time = 0L;
        CramRecordReader reader = new CramRecordReader();
        f.buildReader(reader, new DefaultBitInputStream(new ByteArrayInputStream(s.coreBlock.getRawContent())), inputMap, h, s.sequenceId);
        ArrayList<CramCompressionRecord> records = new ArrayList<CramCompressionRecord>();
        long readNanos = 0L;
        int prevStart = s.alignmentStart;
        for (int i = 0; i < s.nofRecords; ++i) {
            String name;
            CramCompressionRecord r = new CramCompressionRecord();
            r.sliceIndex = s.index;
            r.index = i;
            try {
                time = System.nanoTime();
                reader.read(r);
                readNanos += System.nanoTime() - time;
            }
            catch (EOFException e) {
                e.printStackTrace();
                throw e;
            }
            r.sequenceName = r.sequenceId == s.sequenceId ? seqName : (r.sequenceId == -1 ? "*" : (name = this.samFileHeader.getSequence(r.sequenceId).getSequenceName()));
            records.add(r);
            if (!h.AP_seriesDelta) continue;
            r.alignmentStart = prevStart += r.alignmentDelta;
        }
        log.debug("Slice records read time: " + readNanos / 1000000L);
        Map<String, DataReaderFactory.DataReaderWithStats> statMap = f.getStats(reader);
        for (String key : statMap.keySet()) {
            long value = 0L;
            if (!this.nanoMap.containsKey(key)) {
                this.nanoMap.put(key, 0L);
                value = 0L;
            } else {
                value = this.nanoMap.get(key);
            }
            this.nanoMap.put(key, value + statMap.get((Object)key).nanos);
        }
        return records;
    }
}

