/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.encoding.writer.DataWriterFactory;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerFactory {
    SAMFileHeader samFileHeader;
    int recordsPerSlice = 10000;
    boolean preserveReadNames = true;
    long globalRecordCounter = 0L;
    boolean AP_delta = true;

    public ContainerFactory(SAMFileHeader samFileHeader, int recordsPerSlice) {
        this.samFileHeader = samFileHeader;
        this.recordsPerSlice = recordsPerSlice;
    }

    public Container buildContainer(List<CramCompressionRecord> records) throws IllegalArgumentException, IllegalAccessException, IOException {
        return this.buildContainer(records, null);
    }

    public Container buildContainer(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix) throws IllegalArgumentException, IllegalAccessException, IOException {
        long time1 = System.nanoTime();
        CompressionHeader h = new CompressionHeaderFactory().build(records, substitutionMatrix);
        h.AP_seriesDelta = this.AP_delta;
        long time2 = System.nanoTime();
        h.readNamesIncluded = this.preserveReadNames;
        h.AP_seriesDelta = true;
        ArrayList<Slice> slices = new ArrayList<Slice>();
        Container c = new Container();
        c.h = h;
        c.nofRecords = records.size();
        c.globalRecordCounter = this.globalRecordCounter;
        c.bases = 0L;
        c.blockCount = 0;
        long time3 = System.nanoTime();
        long lastGlobalRecordCounter = c.globalRecordCounter;
        for (int i = 0; i < records.size(); i += this.recordsPerSlice) {
            List<CramCompressionRecord> sliceRecords = records.subList(i, Math.min(records.size(), i + this.recordsPerSlice));
            Slice slice = ContainerFactory.buildSlice(sliceRecords, h, this.samFileHeader);
            slice.globalRecordCounter = lastGlobalRecordCounter;
            lastGlobalRecordCounter += (long)slice.nofRecords;
            c.bases += slice.bases;
            slices.add(slice);
            if (c.sequenceId != -1 || slice.sequenceId == -1) continue;
            c.sequenceId = slice.sequenceId;
        }
        long time4 = System.nanoTime();
        c.slices = slices.toArray(new Slice[slices.size()]);
        ContainerFactory.calculateAlignmentBoundaries(c);
        c.buildHeaderTime = time2 - time1;
        c.buildSlicesTime = time4 - time3;
        this.globalRecordCounter += (long)records.size();
        return c;
    }

    private static void calculateAlignmentBoundaries(Container c) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Slice s : c.slices) {
            if (s.sequenceId == -1) continue;
            start = Math.min(start, s.alignmentStart);
            end = Math.max(end, s.alignmentStart + s.alignmentSpan);
        }
        if (start < Integer.MAX_VALUE) {
            c.alignmentStart = start;
            c.alignmentSpan = end - start;
        }
    }

    private static Slice buildSlice(List<CramCompressionRecord> records, CompressionHeader h, SAMFileHeader fileHeader) throws IllegalArgumentException, IllegalAccessException, IOException {
        HashMap<Integer, ExposedByteArrayOutputStream> map = new HashMap<Integer, ExposedByteArrayOutputStream>();
        for (int id : h.externalIds) {
            map.put(id, new ExposedByteArrayOutputStream());
        }
        DataWriterFactory f = new DataWriterFactory();
        ExposedByteArrayOutputStream bitBAOS = new ExposedByteArrayOutputStream();
        DefaultBitOutputStream bos = new DefaultBitOutputStream(bitBAOS);
        Slice slice = new Slice();
        slice.nofRecords = records.size();
        slice.sequenceId = -1;
        int minAlStart = Integer.MAX_VALUE;
        int maxAlEnd = 0;
        for (CramCompressionRecord r : records) {
            slice.bases += (long)r.readLength;
            if (slice.sequenceId == -2 || r.alignmentStart == 0 || r.sequenceId == -1) continue;
            switch (slice.sequenceId) {
                case -1: {
                    slice.sequenceId = r.sequenceId;
                    break;
                }
                case -2: {
                    break;
                }
                default: {
                    if (slice.sequenceId == r.sequenceId) break;
                    slice.sequenceId = -1;
                }
            }
            minAlStart = Math.min(r.alignmentStart, minAlStart);
            maxAlEnd = Math.max(r.getAlignmentEnd(), maxAlEnd);
        }
        if (slice.sequenceId == -2 || minAlStart == Integer.MAX_VALUE) {
            slice.alignmentStart = 0;
            slice.alignmentSpan = 0;
        } else {
            slice.alignmentStart = minAlStart;
            slice.alignmentSpan = maxAlEnd - minAlStart + 1;
        }
        Writer writer = f.buildWriter(bos, map, h, slice.sequenceId);
        int prevAlStart = slice.alignmentStart;
        for (CramCompressionRecord r : records) {
            r.alignmentDelta = r.alignmentStart - prevAlStart;
            prevAlStart = r.alignmentStart;
            writer.write(r);
        }
        slice.contentType = slice.alignmentSpan > -1 ? BlockContentType.MAPPED_SLICE : BlockContentType.RESERVED;
        bos.close();
        slice.coreBlock = new Block();
        slice.coreBlock.method = BlockCompressionMethod.RAW;
        slice.coreBlock.setRawContent(bitBAOS.toByteArray());
        slice.coreBlock.contentType = BlockContentType.CORE;
        slice.external = new HashMap<Integer, Block>();
        for (Integer i : map.keySet()) {
            ExposedByteArrayOutputStream os = (ExposedByteArrayOutputStream)map.get(i);
            Block externalBlock = new Block();
            externalBlock.contentType = BlockContentType.EXTERNAL;
            externalBlock.method = BlockCompressionMethod.GZIP;
            externalBlock.contentId = i;
            externalBlock.setRawContent(os.toByteArray());
            slice.external.put(i, externalBlock);
        }
        return slice;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }
}

