/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.HuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.HuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.encoding.SubexpIntegerEncoding;
import htsjdk.samtools.cram.encoding.huffman.HuffmanCode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class CompressionHeaderFactory {
    private static final Charset charset = Charset.forName("US-ASCII");
    private static Log log = Log.getInstance(CompressionHeaderFactory.class);
    private static final int oqz = ReadTag.nameType3BytesToInt("OQ", 'Z');
    private static final int bqz = ReadTag.nameType3BytesToInt("OQ", 'Z');

    public CompressionHeader build(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix) {
        CompressionHeader h = new CompressionHeader();
        h.externalIds = new ArrayList<Integer>();
        int exCounter = 0;
        int baseID = exCounter++;
        h.externalIds.add(baseID);
        int qualityScoreID = exCounter++;
        h.externalIds.add(qualityScoreID);
        int readNameID = exCounter++;
        h.externalIds.add(readNameID);
        int mateInfoID = exCounter++;
        h.externalIds.add(mateInfoID);
        int tagValueExtID = exCounter++;
        h.externalIds.add(tagValueExtID);
        log.debug("Assigned external id to bases: " + baseID);
        log.debug("Assigned external id to quality scores: " + qualityScoreID);
        log.debug("Assigned external id to read names: " + readNameID);
        log.debug("Assigned external id to mate info: " + mateInfoID);
        log.debug("Assigned external id to tag values: " + tagValueExtID);
        h.eMap = new TreeMap<EncodingKey, EncodingParams>();
        for (EncodingKey key : EncodingKey.values()) {
            h.eMap.put(key, NullEncoding.toParam());
        }
        h.tMap = new TreeMap<Integer, EncodingParams>();
        CompressionHeaderFactory.getOptimalIntegerEncoding(h, EncodingKey.BF_BitFlags, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h, EncodingKey.CF_CompressionBitFlags, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h, EncodingKey.RI_RefId, -2, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h, EncodingKey.RL_ReadLength, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h, EncodingKey.AP_AlignmentPositionOffset, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h, EncodingKey.RG_ReadGroup, -1, records);
        Object calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            ((HuffmanParamsCalculator)calculator).add(r.readName.length());
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.RN_ReadName, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()), ExternalByteArrayEncoding.toParam(readNameID)));
        IntegerEncodingCalculator calc = new IntegerEncodingCalculator(EncodingKey.NF_RecordsToNextFragment.name(), 0);
        for (CramCompressionRecord r : records) {
            if (!r.isHasMateDownStream()) continue;
            calc.addValue(r.recordsToNextFragment);
        }
        Encoding<Integer> bestEncoding = calc.getBestEncoding();
        h.eMap.put(EncodingKey.NF_RecordsToNextFragment, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            ((HuffmanParamsCalculator)calculator).add(r.tags == null ? 0 : r.tags.length);
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.TC_TagCount, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            if (r.tags == null) continue;
            for (ReadTag tag : r.tags) {
                ((HuffmanParamsCalculator)calculator).add(tag.keyType3BytesAsInt);
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.TN_TagNameAndType, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        Comparator<ReadTag> comparator = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag o1, ReadTag o2) {
                return o1.keyType3BytesAsInt - o2.keyType3BytesAsInt;
            }
        };
        Comparator<byte[]> baComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (o1.length - o2.length != 0) {
                    return o1.length - o2.length;
                }
                for (int i = 0; i < o1.length; ++i) {
                    if (o1[i] == o2[i]) continue;
                    return o1[i] - o2[i];
                }
                return 0;
            }
        };
        TreeMap<byte[], MutableInt> map = new TreeMap<byte[], MutableInt>(baComparator);
        MutableInt noTagCounter = new MutableInt();
        map.put(new byte[0], noTagCounter);
        for (CramCompressionRecord r : records) {
            if (r.tags == null) {
                ++noTagCounter.value;
                r.tagIdsIndex = noTagCounter;
                continue;
            }
            Arrays.sort(r.tags, comparator);
            r.tagIds = new byte[r.tags.length * 3];
            int tagIndex = 0;
            for (int i = 0; i < r.tags.length; ++i) {
                r.tagIds[i * 3] = (byte)r.tags[tagIndex].keyType3Bytes.charAt(0);
                r.tagIds[i * 3 + 1] = (byte)r.tags[tagIndex].keyType3Bytes.charAt(1);
                r.tagIds[i * 3 + 2] = (byte)r.tags[tagIndex].keyType3Bytes.charAt(2);
                ++tagIndex;
            }
            MutableInt count = (MutableInt)map.get(r.tagIds);
            if (count == null) {
                count = new MutableInt();
                map.put(r.tagIds, count);
            }
            ++count.value;
            r.tagIdsIndex = count;
        }
        byte[][][] dic = new byte[map.size()][][];
        int i = 0;
        HuffmanParamsCalculator calculator2 = new HuffmanParamsCalculator();
        for (byte[] idsAsBytes : map.keySet()) {
            int nofIds = idsAsBytes.length / 3;
            dic[i] = new byte[nofIds][];
            int j = 0;
            while (j < idsAsBytes.length) {
                int idIndex = j / 3;
                dic[i][idIndex] = new byte[3];
                dic[i][idIndex][0] = idsAsBytes[j++];
                dic[i][idIndex][1] = idsAsBytes[j++];
                dic[i][idIndex][2] = idsAsBytes[j++];
            }
            calculator2.add(i, ((MutableInt)map.get((Object)idsAsBytes)).value);
            ((MutableInt)map.get((Object)idsAsBytes)).value = i++;
        }
        calculator2.calculate();
        h.eMap.put(EncodingKey.TL_TagIdList, HuffmanIntegerEncoding.toParam(calculator2.values(), calculator2.bitLens()));
        h.dictionary = dic;
        TreeMap<Integer, HuffmanParamsCalculator> cc = new TreeMap<Integer, HuffmanParamsCalculator>();
        for (CramCompressionRecord r : records) {
            if (r.tags == null) continue;
            for (ReadTag tag : r.tags) {
                switch (tag.keyType3BytesAsInt) {
                    default: 
                }
                HuffmanParamsCalculator c = (HuffmanParamsCalculator)cc.get(tag.keyType3BytesAsInt);
                if (c == null) {
                    c = new HuffmanParamsCalculator();
                    cc.put(tag.keyType3BytesAsInt, c);
                }
                c.add(tag.getValueAsByteArray().length);
            }
        }
        if (!cc.isEmpty()) {
            for (Integer key : cc.keySet()) {
                HuffmanParamsCalculator c = (HuffmanParamsCalculator)cc.get(key);
                c.calculate();
                h.tMap.put(key, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(c.values(), c.bitLens()), ExternalByteArrayEncoding.toParam(tagValueExtID)));
            }
        }
        for (Integer key : h.tMap.keySet()) {
            log.debug(String.format("TAG ENCODING: %d, %s", key, h.tMap.get(key)));
        }
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            ((HuffmanParamsCalculator)calculator).add(r.readFeatures == null ? 0 : r.readFeatures.size());
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.FN_NumberOfReadFeatures, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        calc = new IntegerEncodingCalculator("read feature position", 0);
        for (CramCompressionRecord r : records) {
            int prevPos = 0;
            if (r.readFeatures == null) continue;
            for (ReadFeature rf : r.readFeatures) {
                calc.addValue(rf.getPosition() - prevPos);
                prevPos = rf.getPosition();
            }
        }
        bestEncoding = calc.getBestEncoding();
        h.eMap.put(EncodingKey.FP_FeaturePosition, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            if (r.readFeatures == null) continue;
            for (ReadFeature rf : r.readFeatures) {
                ((HuffmanParamsCalculator)calculator).add(rf.getOperator());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.FC_FeatureCode, HuffmanByteEncoding.toParam(((HuffmanParamsCalculator)calculator).valuesAsBytes(), ((HuffmanParamsCalculator)calculator).bitLens));
        h.eMap.put(EncodingKey.BA_Base, ExternalByteEncoding.toParam(baseID));
        h.eMap.put(EncodingKey.QS_QualityScore, ExternalByteEncoding.toParam(qualityScoreID));
        if (substitutionMatrix == null) {
            long[][] freqs = new long[200][200];
            for (CramCompressionRecord r : records) {
                if (r.readFeatures == null) continue;
                for (ReadFeature rf : r.readFeatures) {
                    if (rf.getOperator() != 88) continue;
                    Substitution s = (Substitution)rf;
                    byte refBase = s.getRefernceBase();
                    byte base = s.getBase();
                    long[] lArray = freqs[refBase];
                    byte by = base;
                    lArray[by] = lArray[by] + 1L;
                }
            }
            h.substitutionMatrix = new SubstitutionMatrix(freqs);
        } else {
            h.substitutionMatrix = substitutionMatrix;
        }
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            if (r.readFeatures == null) continue;
            for (ReadFeature rf : r.readFeatures) {
                if (rf.getOperator() != 88) continue;
                Substitution s = (Substitution)rf;
                if (s.getCode() == -1) {
                    byte refBase = s.getRefernceBase();
                    byte base = s.getBase();
                    s.setCode(h.substitutionMatrix.code(refBase, base));
                }
                ((HuffmanParamsCalculator)calculator).add(s.getCode());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.BS_BaseSubstitutionCode, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        h.eMap.put(EncodingKey.IN_Insertion, ByteArrayStopEncoding.toParam((byte)0, baseID));
        h.eMap.put(EncodingKey.SC_SoftClip, ByteArrayStopEncoding.toParam((byte)0, baseID));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            if (r.readFeatures == null) continue;
            for (ReadFeature rf : r.readFeatures) {
                if (rf.getOperator() != 68) continue;
                ((HuffmanParamsCalculator)calculator).add(((Deletion)rf).getLength());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.DL_DeletionLength, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new IntegerEncodingCalculator(EncodingKey.HC_HardClip.name(), 1);
        for (CramCompressionRecord r : records) {
            if (r.readFeatures == null) continue;
            for (ReadFeature rf : r.readFeatures) {
                if (rf.getOperator() != 72) continue;
                ((IntegerEncodingCalculator)calculator).addValue(((HardClip)rf).getLength());
            }
        }
        bestEncoding = ((IntegerEncodingCalculator)calculator).getBestEncoding();
        h.eMap.put(EncodingKey.HC_HardClip, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new IntegerEncodingCalculator(EncodingKey.PD_padding.name(), 1);
        for (CramCompressionRecord r : records) {
            if (r.readFeatures == null) continue;
            for (ReadFeature rf : r.readFeatures) {
                if (rf.getOperator() != 80) continue;
                ((IntegerEncodingCalculator)calculator).addValue(((Padding)rf).getLength());
            }
        }
        bestEncoding = ((IntegerEncodingCalculator)calculator).getBestEncoding();
        h.eMap.put(EncodingKey.PD_padding, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            if (r.readFeatures == null) continue;
            for (ReadFeature rf : r.readFeatures) {
                if (rf.getOperator() != 78) continue;
                ((HuffmanParamsCalculator)calculator).add(((RefSkip)rf).getLength());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.RS_RefSkip, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            if (r.isSegmentUnmapped()) continue;
            ((HuffmanParamsCalculator)calculator).add(r.mappingQuality);
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.MQ_MappingQualityScore, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            ((HuffmanParamsCalculator)calculator).add(r.getMateFlags());
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h.eMap.put(EncodingKey.MF_MateBitFlags, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            if (!r.isDetached()) continue;
            ((HuffmanParamsCalculator)calculator).add(r.mateSequenceID);
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        if (((HuffmanParamsCalculator)calculator).values.length == 0) {
            h.eMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, NullEncoding.toParam());
        }
        h.eMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        log.debug("NS: " + h.eMap.get((Object)EncodingKey.NS_NextFragmentReferenceSequenceID));
        h.eMap.put(EncodingKey.NP_NextFragmentAlignmentStart, ExternalIntegerEncoding.toParam(mateInfoID));
        h.eMap.put(EncodingKey.TS_InsetSize, ExternalIntegerEncoding.toParam(mateInfoID));
        return h;
    }

    private static final int getValue(EncodingKey key, CramCompressionRecord r) {
        switch (key) {
            case AP_AlignmentPositionOffset: {
                return r.alignmentDelta;
            }
            case BF_BitFlags: {
                return r.flags;
            }
            case CF_CompressionBitFlags: {
                return r.compressionFlags;
            }
            case FN_NumberOfReadFeatures: {
                return r.readFeatures == null ? 0 : r.readFeatures.size();
            }
            case MF_MateBitFlags: {
                return r.mateFlags;
            }
            case MQ_MappingQualityScore: {
                return r.mappingQuality;
            }
            case NF_RecordsToNextFragment: {
                return r.recordsToNextFragment;
            }
            case NP_NextFragmentAlignmentStart: {
                return r.mateAlignmentStart;
            }
            case NS_NextFragmentReferenceSequenceID: {
                return r.mateSequenceID;
            }
            case RG_ReadGroup: {
                return r.readGroupID;
            }
            case RI_RefId: {
                return r.sequenceId;
            }
            case RL_ReadLength: {
                return r.readLength;
            }
            case TC_TagCount: {
                return r.tags == null ? 0 : r.tags.length;
            }
        }
        throw new RuntimeException("Unexpected encoding key: " + key.name());
    }

    private static final void getOptimalIntegerEncoding(CompressionHeader h, EncodingKey key, int minValue, List<CramCompressionRecord> records) {
        IntegerEncodingCalculator calc = new IntegerEncodingCalculator(key.name(), minValue);
        for (CramCompressionRecord r : records) {
            int value = CompressionHeaderFactory.getValue(key, r);
            calc.addValue(value);
        }
        Encoding<Integer> bestEncoding = calc.getBestEncoding();
        h.eMap.put(key, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
    }

    private static Integer[] autobox(int[] array) {
        Integer[] newArray = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static class IntegerEncodingCalculator {
        public List<EncodingLengthCalculator> calcs = new ArrayList<EncodingLengthCalculator>();
        private int max = 0;
        private int count = 0;
        private String name;
        private HashMap<Integer, MutableInt> dictionary = new HashMap();
        private int dictionaryThreshold = 100;

        public IntegerEncodingCalculator(String name, int dictionaryThreshold, int minValue) {
            this.name = name;
            this.calcs.add(new EncodingLengthCalculator(new GammaIntegerEncoding(1 - minValue)));
            for (int i = 2; i < 5; ++i) {
                this.calcs.add(new EncodingLengthCalculator(new SubexpIntegerEncoding(0 - minValue, i)));
            }
            this.dictionary = dictionaryThreshold < 1 ? null : new HashMap();
        }

        public IntegerEncodingCalculator(String name, int minValue) {
            this(name, 255, minValue);
        }

        public void addValue(int value) {
            ++this.count;
            if (value > this.max) {
                this.max = value;
            }
            for (EncodingLengthCalculator c : this.calcs) {
                c.add(value);
            }
            if (this.dictionary != null) {
                if (this.dictionary.size() >= this.dictionaryThreshold - 1) {
                    this.dictionary = null;
                } else {
                    MutableInt m = this.dictionary.get(value);
                    if (m == null) {
                        m = new MutableInt();
                        this.dictionary.put(value, m);
                    }
                    ++m.value;
                }
            }
        }

        public Encoding<Integer> getBestEncoding() {
            int betaLength;
            if (this.dictionary != null && this.dictionary.size() == 1) {
                int value = this.dictionary.keySet().iterator().next();
                EncodingParams param = HuffmanIntegerEncoding.toParam(new int[]{value}, new int[]{0});
                HuffmanIntegerEncoding he = new HuffmanIntegerEncoding();
                he.fromByteArray(param.params);
                return he;
            }
            EncodingLengthCalculator bestC = this.calcs.get(0);
            for (EncodingLengthCalculator c : this.calcs) {
                if (c.len() >= bestC.len()) continue;
                bestC = c;
            }
            Encoding bestEncoding = bestC.encoding;
            long bits = bestC.len();
            if (bits > (long)((betaLength = (int)Math.round(Math.log(this.max) / Math.log(2.0) + 0.5)) * this.count)) {
                bestEncoding = new BetaIntegerEncoding(betaLength);
                bits = betaLength * this.count;
            }
            if (this.dictionary != null) {
                HuffmanParamsCalculator c = new HuffmanParamsCalculator();
                for (Integer value : this.dictionary.keySet()) {
                    c.add(value, this.dictionary.get((Object)value).value);
                }
                c.calculate();
                EncodingParams param = HuffmanIntegerEncoding.toParam(c.values(), c.bitLens());
                HuffmanIntegerEncoding he = new HuffmanIntegerEncoding();
                he.fromByteArray(param.params);
                EncodingLengthCalculator lc = new EncodingLengthCalculator(he);
                for (Integer value : this.dictionary.keySet()) {
                    lc.add(value, this.dictionary.get((Object)value).value);
                }
                if (lc.len() < bits) {
                    bestEncoding = he;
                    bits = lc.len();
                }
            }
            byte[] params = bestEncoding.toByteArray();
            params = Arrays.copyOf(params, Math.min(params.length, 20));
            log.debug("Best encoding for " + this.name + ": " + bestEncoding.id().name() + Arrays.toString(params));
            return bestEncoding;
        }
    }

    public static class EncodingLengthCalculator {
        private BitCodec<Integer> codec;
        private Encoding<Integer> encoding;
        private long len;

        public EncodingLengthCalculator(Encoding<Integer> encoding) {
            this.encoding = encoding;
            this.codec = encoding.buildCodec(null, null);
        }

        public void add(int value) {
            this.len += this.codec.numberOfBits(value);
        }

        public void add(int value, int inc) {
            this.len += (long)inc * this.codec.numberOfBits(value);
        }

        public long len() {
            return this.len;
        }
    }

    public static class HuffmanParamsCalculator {
        private HashMap<Integer, MutableInt> countMap = new HashMap();
        private int[] values = new int[0];
        private int[] bitLens = new int[0];

        public void add(int value) {
            MutableInt counter = this.countMap.get(value);
            if (counter == null) {
                counter = new MutableInt();
                this.countMap.put(value, counter);
            }
            ++counter.value;
        }

        public void add(Integer value, int inc) {
            MutableInt counter = this.countMap.get(value);
            if (counter == null) {
                counter = new MutableInt();
                this.countMap.put(value, counter);
            }
            counter.value += inc;
        }

        public int[] bitLens() {
            return this.bitLens;
        }

        public int[] values() {
            return this.values;
        }

        public Integer[] valuesAsAutoIntegers() {
            Integer[] ivalues = new Integer[this.values.length];
            for (int i = 0; i < ivalues.length; ++i) {
                ivalues[i] = this.values[i];
            }
            return ivalues;
        }

        public byte[] valuesAsBytes() {
            byte[] bvalues = new byte[this.values.length];
            for (int i = 0; i < bvalues.length; ++i) {
                bvalues[i] = (byte)(0xFF & this.values[i]);
            }
            return bvalues;
        }

        public Byte[] valuesAsAutoBytes() {
            Byte[] bvalues = new Byte[this.values.length];
            for (int i = 0; i < bvalues.length; ++i) {
                bvalues[i] = (byte)(0xFF & this.values[i]);
            }
            return bvalues;
        }

        public void calculate() {
            HuffmanTree<Integer> tree = null;
            int size = this.countMap.size();
            int[] freqs = new int[size];
            int[] values = new int[size];
            int i = 0;
            for (Integer v : this.countMap.keySet()) {
                values[i] = v;
                freqs[i] = this.countMap.get((Object)v).value;
                ++i;
            }
            tree = HuffmanCode.buildTree(freqs, CompressionHeaderFactory.autobox(values));
            ArrayList valueList = new ArrayList();
            ArrayList<Integer> lens = new ArrayList<Integer>();
            HuffmanCode.getValuesAndBitLengths(valueList, lens, tree);
            Object[] codes = new BitCode[valueList.size()];
            for (i = 0; i < valueList.size(); ++i) {
                codes[i] = new BitCode((Integer)valueList.get(i), (Integer)lens.get(i));
            }
            Arrays.sort(codes);
            this.values = new int[codes.length];
            this.bitLens = new int[codes.length];
            for (i = 0; i < codes.length; ++i) {
                Object code = codes[i];
                this.bitLens[i] = ((BitCode)code).len;
                this.values[i] = ((BitCode)code).value;
            }
        }
    }

    private static class BitCode
    implements Comparable<BitCode> {
        int value;
        int len;

        public BitCode(int value, int len) {
            this.value = value;
            this.len = len;
        }

        @Override
        public int compareTo(BitCode o) {
            int result = this.value - o.value;
            if (result != 0) {
                return result;
            }
            return this.len - o.len;
        }
    }
}

