/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.security.PrivateKey;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.engine.phonehome.GATKRunReport;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.CommandLineProgram;
import org.broadinstitute.gatk.utils.crypt.CryptUtils;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.io.IOUtils;

public class EncryptAWSKeys
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(EncryptAWSKeys.class);
    @Argument(fullName="access", shortName="access", doc="The AWS access key for the GATK user account", required=true)
    private String awsAccessKey;
    @Argument(fullName="secret", shortName="secret", doc="The AWS secret key for the GATK user account", required=true)
    private String awsSecretKey;
    @Argument(fullName="path", shortName="path", doc="The default path for the files", required=false)
    private String outputDirectory = "public/java/src/org/broadinstitute/sting/gatk/phonehome/resources/";
    public static final String ACCESS_KEY_FILENAME = "GATK_AWS_access.key";
    public static final String SECRET_KEY_FILENAME = "GATK_AWS_secret.key";

    @Override
    protected int execute() throws Exception {
        File accessKeyFile = new File(this.outputDirectory, ACCESS_KEY_FILENAME);
        File secretKeyFile = new File(this.outputDirectory, SECRET_KEY_FILENAME);
        PrivateKey key = CryptUtils.loadGATKMasterPrivateKey();
        this.writeAndCheckAWSKey(this.awsAccessKey, key, accessKeyFile);
        this.writeAndCheckAWSKey(this.awsSecretKey, key, secretKeyFile);
        logger.info((Object)"Successfully wrote key pair to files:");
        logger.info((Object)String.format("Access Key: %s with md5 %s", accessKeyFile, Utils.calcMD5(this.awsAccessKey)));
        logger.info((Object)String.format("Secret Key: %s with md5 %s", secretKeyFile, Utils.calcMD5(this.awsSecretKey)));
        return 0;
    }

    private void writeAndCheckAWSKey(String awsKey, PrivateKey encryptKey, File destination) throws FileNotFoundException {
        byte[] encrypted = CryptUtils.encryptData(awsKey.getBytes(), encryptKey);
        IOUtils.writeByteArrayToFile(encrypted, destination);
        byte[] fromDisk = IOUtils.readFileIntoByteArray(destination);
        if (!Arrays.equals(encrypted, fromDisk)) {
            throw new UserException("Bytes from disk not equal to encrypted bytes in memory");
        }
        String readKey = GATKRunReport.decryptAWSKey((File)destination);
        logger.info((Object)("Read " + readKey + " from " + destination + " should be equal to " + awsKey));
        if (!awsKey.equals(readKey)) {
            throw new UserException("Decrypting file not equal to the given AWS key");
        }
    }

    public static void main(String[] args) {
        try {
            EncryptAWSKeys instance = new EncryptAWSKeys();
            EncryptAWSKeys.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e) {
            EncryptAWSKeys.exitSystemWithUserError(e);
        }
        catch (Exception e) {
            EncryptAWSKeys.exitSystemWithError(e);
        }
    }
}

