/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.Iterator;

public class IntervalUtil {
    public static boolean contains(Interval interval, String sequenceName, long position) {
        return interval.getSequence().equals(sequenceName) && position >= (long)interval.getStart() && position <= (long)interval.getEnd();
    }

    public static boolean contains(IntervalList intervalList, String sequenceName, long position) {
        for (Interval interval : intervalList.getUniqueIntervals()) {
            if (!IntervalUtil.contains(interval, sequenceName, position)) continue;
            return true;
        }
        return false;
    }

    public static void assertOrderedNonOverlapping(Iterator<Interval> intervals, SAMSequenceDictionary sequenceDictionary) {
        if (!intervals.hasNext()) {
            return;
        }
        Interval prevInterval = intervals.next();
        int prevSequenceIndex = sequenceDictionary.getSequenceIndex(prevInterval.getSequence());
        while (intervals.hasNext()) {
            Interval interval = intervals.next();
            if (prevInterval.intersects(interval)) {
                throw new SAMException("Intervals should not overlap: " + prevInterval + "; " + interval);
            }
            int thisSequenceIndex = sequenceDictionary.getSequenceIndex(interval.getSequence());
            if (prevSequenceIndex > thisSequenceIndex || prevSequenceIndex == thisSequenceIndex && prevInterval.compareTo(interval) >= 0) {
                throw new SAMException("Intervals not in order: " + prevInterval + "; " + interval);
            }
            prevInterval = interval;
            prevSequenceIndex = thisSequenceIndex;
        }
    }
}

