/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.io.InputStream;

class SAMTextReader
extends SAMFileReader.ReaderImplementation {
    private SAMRecordFactory samRecordFactory;
    private BufferedLineReader mReader;
    private SAMFileHeader mFileHeader = null;
    private String mCurrentLine = null;
    private RecordIterator mIterator = null;
    private File mFile = null;
    private ValidationStringency validationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private SamReader mParentReader;

    public SAMTextReader(InputStream stream, ValidationStringency validationStringency, SAMRecordFactory factory) {
        this.mReader = new BufferedLineReader(stream);
        this.validationStringency = validationStringency;
        this.samRecordFactory = factory;
        this.readHeader();
    }

    public SAMTextReader(InputStream stream, File file, ValidationStringency validationStringency, SAMRecordFactory factory) {
        this(stream, validationStringency, factory);
        this.mFile = file;
    }

    @Override
    public void enableFileSource(SamReader reader, boolean enabled) {
        this.mParentReader = enabled ? reader : null;
    }

    @Override
    void enableIndexCaching(boolean enabled) {
        throw new UnsupportedOperationException("Cannot enable index caching for a SAM text reader");
    }

    @Override
    void enableIndexMemoryMapping(boolean enabled) {
        throw new UnsupportedOperationException("Cannot enable index memory mapping for a SAM text reader");
    }

    @Override
    void enableCrcChecking(boolean enabled) {
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory factory) {
        this.samRecordFactory = factory;
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.SAM_TYPE;
    }

    @Override
    public boolean hasIndex() {
        return false;
    }

    @Override
    public BAMIndex getIndex() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            finally {
                this.mReader = null;
            }
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public void setValidationStringency(ValidationStringency stringency) {
        this.validationStringency = stringency;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator() {
        if (this.mReader == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        this.mIterator = new RecordIterator();
        return this.mIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan fileSpan) {
        throw new UnsupportedOperationException("Cannot directly iterate over regions within SAM text files.");
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        throw new UnsupportedOperationException("Cannot retrieve file pointers within SAM text files.");
    }

    public CloseableIterator<SAMRecord> query(String sequence, int start, int end, boolean contained) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] intervals, boolean contained) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    private void readHeader() {
        SAMTextHeaderCodec headerCodec = new SAMTextHeaderCodec();
        headerCodec.setValidationStringency(this.validationStringency);
        this.mFileHeader = headerCodec.decode(this.mReader, this.mFile != null ? this.mFile.toString() : null);
        this.advanceLine();
    }

    private String advanceLine() {
        this.mCurrentLine = this.mReader.readLine();
        return this.mCurrentLine;
    }

    private class RecordIterator
    implements CloseableIterator<SAMRecord> {
        private final SAMLineParser parser;

        private RecordIterator() {
            this.parser = new SAMLineParser(SAMTextReader.this.samRecordFactory, SAMTextReader.this.validationStringency, SAMTextReader.this.mFileHeader, SAMTextReader.this.mParentReader, SAMTextReader.this.mFile);
            if (SAMTextReader.this.mReader == null) {
                throw new IllegalStateException("Reader is closed.");
            }
        }

        @Override
        public void close() {
            SAMTextReader.this.close();
        }

        @Override
        public boolean hasNext() {
            return SAMTextReader.this.mCurrentLine != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Cannot call next() on exhausted iterator");
            }
            try {
                SAMRecord sAMRecord = this.parseLine();
                return sAMRecord;
            }
            finally {
                SAMTextReader.this.advanceLine();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        private SAMRecord parseLine() {
            return this.parser.parseLine(SAMTextReader.this.mCurrentLine, SAMTextReader.this.mReader.getLineNumber());
        }
    }
}

