/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.HashMap;
import java.util.Random;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class DownsampleSam
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + " Randomly down-sample a SAM or BAM file to retain " + "a random subset of the reads. Mate-pairs are either both kept or both discarded. Reads marked as not primary " + "alignments are all discarded. Each read is given a probability P of being retained - results with the exact " + "same input in the same order and with the same value for RANDOM_SEED will produce the same results.";
    @Option(shortName="I", doc="The input SAM or BAM file to downsample.")
    public File INPUT;
    @Option(shortName="O", doc="The output, downsampled, SAM or BAM file to write.")
    public File OUTPUT;
    @Option(shortName="R", doc="Random seed to use if reproducibilty is desired.  Setting to null will cause multiple invocations to produce different results.")
    public Long RANDOM_SEED = 1L;
    @Option(shortName="P", doc="The probability of keeping any individual read, between 0 and 1.")
    public double PROBABILITY = 1.0;
    private final Log log = Log.getInstance(DownsampleSam.class);

    public static void main(String[] args) {
        new DownsampleSam().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        Random r = this.RANDOM_SEED == null ? new Random() : new Random(this.RANDOM_SEED);
        SAMFileReader in = new SAMFileReader(this.INPUT);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(in.getFileHeader(), true, this.OUTPUT);
        HashMap<String, Boolean> decisions = new HashMap<String, Boolean>();
        long total = 0L;
        long kept = 0L;
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Read");
        for (SAMRecord rec : in) {
            boolean keeper;
            if (rec.isSecondaryOrSupplementary()) continue;
            ++total;
            String key = rec.getReadName();
            Boolean previous = (Boolean)decisions.remove(key);
            if (previous == null) {
                boolean bl = keeper = r.nextDouble() <= this.PROBABILITY;
                if (rec.getReadPairedFlag()) {
                    decisions.put(key, keeper);
                }
            } else {
                keeper = previous;
            }
            if (keeper) {
                out.addAlignment(rec);
                ++kept;
            }
            progress.record(rec);
        }
        out.close();
        this.log.info(new Object[]{"Finished! Kept " + kept + " out of " + total + " reads."});
        return 0;
    }
}

