/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.CoordinateSortedPairInfoMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Map;
import picard.PicardException;
import picard.sam.ReadEnds;
import picard.sam.ReadEndsCodec;
import picard.sam.ReadEndsMap;

class DiskReadEndsMap
implements ReadEndsMap {
    private final CoordinateSortedPairInfoMap<String, ReadEnds> pairInfoMap;

    DiskReadEndsMap(int maxOpenFiles) {
        this.pairInfoMap = new CoordinateSortedPairInfoMap(maxOpenFiles, (CoordinateSortedPairInfoMap.Codec)new Codec());
    }

    @Override
    public ReadEnds remove(int mateSequenceIndex, String key) {
        return (ReadEnds)this.pairInfoMap.remove(mateSequenceIndex, (Object)key);
    }

    @Override
    public void put(int mateSequenceIndex, String key, ReadEnds readEnds) {
        this.pairInfoMap.put(mateSequenceIndex, (Object)key, (Object)readEnds);
    }

    @Override
    public int size() {
        return this.pairInfoMap.size();
    }

    @Override
    public int sizeInRam() {
        return this.pairInfoMap.sizeInRam();
    }

    private static class Codec
    implements CoordinateSortedPairInfoMap.Codec<String, ReadEnds> {
        private final ReadEndsCodec readEndsCodec = new ReadEndsCodec();

        private Codec() {
        }

        public void setInputStream(InputStream is) {
            this.readEndsCodec.setInputStream(is);
        }

        public void setOutputStream(OutputStream os) {
            this.readEndsCodec.setOutputStream(os);
        }

        public Map.Entry<String, ReadEnds> decode() {
            try {
                String key = this.readEndsCodec.getInputStream().readUTF();
                ReadEnds record = this.readEndsCodec.decode();
                return new AbstractMap.SimpleEntry<String, ReadEnds>(key, record);
            }
            catch (IOException e) {
                throw new PicardException("Error loading ReadEndsMap from disk", e);
            }
        }

        public void encode(String key, ReadEnds readEnds) {
            try {
                this.readEndsCodec.getOutputStream().writeUTF(key);
                this.readEndsCodec.encode(readEnds);
            }
            catch (IOException e) {
                throw new PicardException("Error spilling ReadEndsMap to disk.", e);
            }
        }
    }
}

