/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Comparator;
import net.sf.samtools.SAMRecord;

public class AlignmentStartWithNoTiesComparator
implements Comparator<SAMRecord> {
    @Requires(value={"c1 >= 0 && c2 >= 0"})
    @Ensures(value={"result == 0 || result == 1 || result == -1"})
    private int compareContigs(int c1, int c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 > c2) {
            return 1;
        }
        return -1;
    }

    @Override
    @Requires(value={"r1 != null && r2 != null"})
    @Ensures(value={"result == 0 || result == 1 || result == -1"})
    public int compare(SAMRecord r1, SAMRecord r2) {
        int cmpContig;
        int result = r1 == r2 ? 0 : (r1.getReadUnmappedFlag() ? 1 : (r2.getReadUnmappedFlag() ? -1 : ((cmpContig = this.compareContigs(r1.getReferenceIndex(), r2.getReferenceIndex())) != 0 ? cmpContig : (r1.getAlignmentStart() < r2.getAlignmentStart() ? -1 : 1))));
        return result;
    }
}

