/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import org.broad.igv.ui.FontManager;

import javax.swing.*;
import java.awt.*;

/**
 * Information panel.  Displayed in upper left corner
 *
 * @author jrobinso
 */
public class NameHeaderPanel extends JPanel {

    JideButton genomeButton;
    JideButton helpButton;

    public NameHeaderPanel() {
        initComponents();

    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        // Ignore layout manager settings
    }

    JEditorPane infoArea;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);

    }

    protected void initComponents() {

        JideBoxLayout layout = new JideBoxLayout(this, JideBoxLayout.Y_AXIS, 2);
        super.setLayout(layout);


        this.add(Box.createHorizontalStrut(10), JideBoxLayout.FIX);

        /* helpButton = new JideButton("Getting started ...");
        helpButton.setForeground(Color.BLUE.darker());
        helpButton.setButtonStyle(ButtonStyle.HYPERLINK_STYLE);
        helpButton.setHorizontalAlignment(SwingConstants.LEFT);
        helpButton.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent actionevent) {
        JOptionPane.showMessageDialog(null, "Under construction");
        }
        });
        this.add(helpButton, JideBoxLayout.FIX);
         * */


        infoArea = new JEditorPane();
        infoArea.setContentType("text/html");
        infoArea.setFont(FontManager.getScalableFont(12));
        // infoArea.setBorder(BorderFactory.createEmptyBorder());

        infoArea.setMargin(new Insets(5, 5, 5, 5));
        infoArea.setEditable(false);
        //infoArea.setLineWrap(true);
        //infoArea.setWrapStyleWord(true);
        //addQuickstartLink();
        this.add(infoArea, JideBoxLayout.VARY);

        //updateHelpText();


    }

    public void updateHelpText() {
        /*infoArea.setText("<html>" + getHelpText()); 
        +
        "<p><a href=\"" + SERVER_BASE_URL + "doc/quickstart.html\">Quick start guide</a>");
        
        infoArea.addHyperlinkListener(new HyperlinkListener() {

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
        try {
        if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
        BrowserLauncher.openURL(hyperlinkevent.getURL().toString());
        }
        } catch (IOException ex) {
        com.jidesoft.dialog.JideOptionPane.showMessageDialog(infoArea, "Cannot connect to tutorial.");
        }
        }
        });
         * */
    }

    private String getHelpText() {
        return "";
    }
}
