/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui;

import org.broad.igv.session.ViewContext;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;

/**
 * @author eflakes
 */
public class RegionOfInterestTool extends IGVTool {

    RegionOfInterest regionOfInterest = null;
    Integer roiStart = null;
    JButton roiButton;

    public RegionOfInterestTool(Component owner, JButton roiButton) {
        super(owner, Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
        this.roiButton = roiButton;
        setName("Region of Interest");
    }

    public int getRoiStart() {
        return (roiStart == null ? 0 : roiStart.intValue());
    }

    /**
     * The mouse has been clicked.  Define one edge of the region of interest.
     */
    @Override
    public void mousePressed(final MouseEvent e) {

        ViewContext viewContext = ViewContext.getInstance();

        if (e.getButton() == MouseEvent.BUTTON1 &&
                e.getClickCount() == 1) {

            Object chromosome = viewContext.getChromosome();

            // Allow Regions of Interest edits if ROI is enabled
            // and we have a valid Chromosome
            if (chromosome != null) {

                String chromosomeName = viewContext.getChrName();
                if (chromosomeName != null) {

                    int x = e.getX();

                    // Create a user Region of Interest
                    if (roiStart == null) {
                        roiStart = (int) viewContext.getChromosomePosition(x);
                        getOwner().repaint();
                    } else {

                        try {

                            int roiEnd = (int) viewContext.getChromosomePosition(x);
                            int start = Math.min(roiStart, roiEnd);
                            int end = Math.max(roiStart, roiEnd);

                            if (start == end) {
                                ++end;
                            }

                            // Create a Region of Interest
                            regionOfInterest =
                                    new RegionOfInterest(
                                            chromosomeName,
                                            start,
                                            end,
                                            null);
                            // TODO -- get this ugly reference out of here
                            IGVMainFrame.getInstance().endROI();
                            IGVMainFrame.getInstance().addRegionOfInterest(regionOfInterest);

                        } finally {
                            roiButton.setSelected(false);
                        }
                    }
                }

                IGVMainFrame.getInstance().doRefresh();
            }
        }
    }

    public RegionOfInterest getRegionOfInterest() {
        return regionOfInterest;
    }
}
