/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.InstanceProfileListByPathRequest;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMInstanceProfileListByPathDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMInstanceProfileListByPathDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof InstanceProfileListByPathRequest) {
            InstanceProfileListByPathRequest listRequest = (InstanceProfileListByPathRequest)request;
            LOG.debug((Object)("Listing Instance Profiles: " + listRequest));
            String pathPrefix = listRequest.getPathPrefix();
            if (pathPrefix == null) {
                pathPrefix = "/";
            }
            ListInstanceProfilesRequest iipListRequest = new ListInstanceProfilesRequest();
            iipListRequest.setPathPrefix(pathPrefix);
            iipListRequest.setMarker(listRequest.getMarker());
            iipListRequest.setMaxItems(listRequest.getMaxItems());
            ListInstanceProfilesResult result = this.getClient().listInstanceProfiles(iipListRequest);
            for (InstanceProfile prof : result.getInstanceProfiles()) {
                LOG.info((Object)prof.getArn());
            }
            LOG.info((Object)("IsTruncated: " + result.getIsTruncated()));
            if (result.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + result.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

