#! /usr/bin/perl -w
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..15$/"; }
END {print "not ok 1$/" unless $loaded;}
use Xray::Absorption;
$loaded = 1;
print "ok 1$/";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$i=1;
$epsilon = 0.0001;
Xray::Absorption -> load("mcmaster");

if (Xray::Absorption -> current_resource =~ /mcmaster/i) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};

if (Xray::Absorption -> in_resource("dy")) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};


## fetch material properties
if (abs(Xray::Absorption -> get_atomic_weight("dy") - 162.510) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_density("dy") - 8.536) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_conversion("dy") - 269.8) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};


## fetch edge energies
if (abs(Xray::Absorption -> get_energy("dy", "k") - 53789) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "l1") - 9047) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "l2") - 8581) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "l3") - 7790) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "m1") - 2046) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};


## fetch fluorescence lines
if (abs(Xray::Absorption -> get_energy("dy", "kalpha") - 45985) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "kbeta") - 52178) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "lalpha") - 6495.2) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "lbeta") - 7247.7) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};


## 'a_k' => [
##            '0.114845e+02',
##            '  0.210451e+01',
##            ' -0.989870e+00',
##            '  0.669382e-01'
##          ],
## 'a_l' => [
##            '0.173446e+02',
##            ' -0.254821e+01',
##            ' -0.317606e-01',
##            '  0.000000e+00'
##          ],
## 'a_m' => [
##            '0.159225e+02',
##            ' -0.265289e+01',
##            '  0.000000e+00',
##            '  0.000000e+00'
##          ],
## 'a_n' => [
##            '0.159225e+02',
##            ' -0.265289e+01',
##            '  0.000000e+00',
##            '  0.000000e+00'
##          ],
## 'incoherent' => [
##                   '0.242685e+00',
##                   '  0.146266e+01',
##                   ' -0.189102e+00',
##                   '  0.385628e-02'
##                 ],
## 'coherent' => [
##                 '0.774188e+01',
##                 '  0.367107e+00',
##                 ' -0.349433e+00',
##                 '  0.166273e-01'
##               ],
## 'ljump_3' => '  0.904700e+01'
