#! /usr/bin/perl -w
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..15$/"; }
END {print "not ok 1$/" unless $loaded;}
use Xray::Absorption;
$loaded = 1;
print "ok 1$/";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$i=1;
$epsilon = 0.0001;
Xray::Absorption -> load("elam");
#print Xray::Absorption -> current_resource, $/;
if (Xray::Absorption -> current_resource =~ /elam/i) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};

if (Xray::Absorption -> in_resource("dy")) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};


## fetch material properties
if (abs(Xray::Absorption -> get_atomic_weight("dy") - 162.510) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_density("dy") - 8.536) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_conversion("dy") - 269.8) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};


## fetch edge energies
if (abs(Xray::Absorption -> get_energy("dy", "k") - 53789) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "l1") - 9046) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "l2") - 8581) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "l3") - 7790) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "m1") - 2047) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};


## fetch fluorescence lines
if (abs(Xray::Absorption -> get_energy("dy", "kalpha") - 45772.309978) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "kbeta") - 52166.8201163) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "lalpha") - 6494.569735) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(Xray::Absorption -> get_energy("dy", "lbeta") - 7354.310914) < $epsilon ) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
