#include <stdio.h>
#include <gpcl/gpc.h>

int main(int argc, char** argv)
{
  gpc_polygon subject, clip, result;
  FILE *sfp, *cfp, *ofp;

  if ( argc < 3 || argc > 4 )
    {
      fprintf (stderr,
	       "Usage: %s subject-file clip-file [result-file]\n",
	       argv[0]);
      return 1;
    }

  sfp = fopen(argv[1], "r");
  if ( sfp == NULL )
    {
      fprintf (stderr, "%s: cannot open file %s\n", argv[0], argv[1]);
      return 1;
    }
  
  cfp = fopen(argv[2], "r");
  if ( cfp == NULL )
    {
      fprintf (stderr, "%s: cannot open file %s\n", argv[0], argv[2]);
      return 1;
    }

  ofp = ( argc == 4 ) ? fopen(argv[3], "w") : stdout;      
  if ( ofp == NULL )
    {
      fprintf (stderr, "%s: cannot open file %s\n", argv[0], argv[2]);
      return 1;
    }

  gpc_read_polygon(sfp, 0, &subject);
  gpc_read_polygon(cfp, 0, &clip);

  gpc_polygon_clip(GPC_INT, &subject, &clip, &result);

  gpc_write_polygon(ofp, 0, &result);

  gpc_free_polygon(&subject);
  gpc_free_polygon(&clip);
  gpc_free_polygon(&result);

  fclose(sfp);
  fclose(cfp);
  fclose(ofp);

  return 0;
}
