/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2004 
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Rendering sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <gpac/intern/m4_render_dev.h>
#include "stacks3d.h"

void R3D_NodeInit(VisualRenderer *vr, SFNode *node)
{
	Render3D *sr = (Render3D *)vr->user_priv;

	switch (Node_GetTag(node)) {
#ifdef M4_DEF_Anchor
	case TAG_Anchor: R3D_InitAnchor(sr, node); break;
#endif
#ifdef M4_DEF_Background2D
	case TAG_Background2D: R3D_InitBackground2D(sr, node); break;
#endif
#ifdef M4_DEF_Bitmap
	case TAG_Bitmap: R3D_InitBitmap(sr, node); break;
#endif
#ifdef M4_DEF_Circle
	case TAG_Circle: R3D_InitCircle(sr, node); break;
#endif
#ifdef M4_DEF_ColorTransform
	case TAG_ColorTransform: R3D_InitColorTransform(sr, node); break;
#endif
#ifdef M4_DEF_CompositeTexture2D
	case TAG_CompositeTexture2D: R3D_InitCompositeTexture2D(sr, node); break;
#endif
#ifdef M4_DEF_Curve2D
	case TAG_Curve2D: R3D_InitCurve2D(sr, node); break;
#endif
#ifdef M4_DEF_XCurve2D
	case TAG_XCurve2D: R3D_InitCurve2D(sr, node); break;
#endif
#ifdef M4_DEF_DiscSensor
	case TAG_DiscSensor: R3D_InitDiscSensor(sr, node); break;
#endif
#ifdef M4_DEF_Ellipse
	case TAG_Ellipse: R3D_InitEllipse(sr, node); break;
#endif
#ifdef M4_DEF_Group
	case TAG_Group: R3D_InitGroup(sr, node); break;
#endif
#ifdef M4_DEF_IndexedFaceSet2D
	case TAG_IndexedFaceSet2D: R3D_InitIFS2D(sr, node); break;
#endif
#ifdef M4_DEF_IndexedLineSet2D
	case TAG_IndexedLineSet2D: R3D_InitILS2D(sr, node); break;
#endif
#ifdef M4_DEF_Form
	case TAG_Form: R3D_InitForm(sr, node); break;
#endif
#ifdef M4_DEF_Layer2D
	case TAG_Layer2D: R3D_InitLayer2D(sr, node); break;
#endif
#ifdef M4_DEF_Layout
	case TAG_Layout: R3D_InitLayout(sr, node); break;
#endif
#ifdef M4_DEF_PointSet2D
	case TAG_PointSet2D: R3D_InitPointSet2D(sr, node); break;
#endif
#ifdef M4_DEF_OrderedGroup
	case TAG_OrderedGroup: R3D_InitOrderedGroup(sr, node); break;
#endif
/*
#ifdef M4_DEF_MatteTexture
	case TAG_MatteTexture: R3D_InitMatteTexture(sr, node); break;
#endif
*/
#ifdef M4_DEF_PlaneSensor2D
	case TAG_PlaneSensor2D: R3D_InitPlaneSensor2D(sr, node); break;
#endif
#ifdef M4_DEF_ProximitySensor2D
	case TAG_ProximitySensor2D: R3D_InitProximitySensor2D(sr, node); break;
#endif
#ifdef M4_DEF_Rectangle
	case TAG_Rectangle: R3D_InitRectangle(sr, node); break;
#endif
#ifdef M4_DEF_Shape
	case TAG_Shape: R3D_InitShape(sr, node); break;
#endif
#ifdef M4_DEF_Switch
	case TAG_Switch: R3D_InitSwitch(sr, node); break;
#endif
#ifdef M4_DEF_Text
	case TAG_Text: R3D_InitText(sr, node); break;
#endif
#ifdef M4_DEF_TouchSensor
	case TAG_TouchSensor: R3D_InitTouchSensor(sr, node); break;
#endif
#ifdef M4_DEF_Transform2D
	case TAG_Transform2D: R3D_InitTransform2D(sr, node); break;
#endif
#ifdef M4_DEF_TransformMatrix2D
	case TAG_TransformMatrix2D: R3D_InitTransformMatrix2D(sr, node); break;
#endif
#ifdef M4_DEF_Viewport
	case TAG_Viewport: R3D_InitViewport(sr, node); break;
#endif
#ifdef M4_DEF_LineProperties
	case TAG_LineProperties: R3D_InitLineProps(sr, node); break;
#endif
#ifdef M4_DEF_XLineProperties
	case TAG_XLineProperties: R3D_InitLineProps(sr, node); break;
#endif


#ifdef M4_DEF_LinearGradient
	case TAG_LinearGradient: R3D_InitLinearGradient(sr, node); break;
#endif
#ifdef M4_DEF_RadialGradient
	case TAG_RadialGradient: R3D_InitRadialGradient(sr, node); break;
#endif
#ifdef M4_DEF_PathLayout
	case TAG_PathLayout: R3D_InitPathLayout(sr, node); break;
#endif
	
	/*3D nodes*/
#ifdef M4_DEF_Box
	case TAG_Box: R3D_InitBox(sr, node); break;
#endif
#ifdef M4_DEF_CompositeTexture3D
	case TAG_CompositeTexture3D: R3D_InitCompositeTexture3D(sr, node); break;
#endif
#ifdef M4_DEF_Cone
	case TAG_Cone: R3D_InitCone(sr, node); break;
#endif
#ifdef M4_DEF_Cylinder
	case TAG_Cylinder: R3D_InitCylinder(sr, node); break;
#endif
#ifdef M4_DEF_Sphere
	case TAG_Sphere: R3D_InitSphere(sr, node); break;
#endif
#ifdef M4_DEF_IndexedFaceSet
	case TAG_IndexedFaceSet: R3D_InitIFS(sr, node); break;
#endif
#ifdef M4_DEF_IndexedLineSet
	case TAG_IndexedLineSet: R3D_InitILS(sr, node); break;
#endif
#ifdef M4_DEF_Transform
	case TAG_Transform: R3D_InitTransform(sr, node); break;
#endif
#ifdef M4_DEF_Viewpoint
	case TAG_Viewpoint: R3D_InitViewpoint(sr, node);  break;
#endif
#ifdef M4_DEF_NavigationInfo
	case TAG_NavigationInfo: R3D_InitNavigationInfo(sr, node);  break;
#endif
	}
}

Bool R3D_NodeChanged(VisualRenderer *vr, SFNode *byObj)
{
	switch (Node_GetTag(byObj)) {
#ifdef M4_DEF_Background2D
	case TAG_Background2D: R3D_Background2DModified(byObj); break;
#endif
/*
#ifdef M4_DEF_MatteTexture
	case TAG_MatteTexture: MatteTextureModified(byObj); break;
#endif	
*/
#ifdef M4_DEF_Layout
	case TAG_Layout: R3D_LayoutModified(byObj); break;
#endif	

	/*let the compositor decide what to do*/
	default: return 0;
	}
	return 0;
}
