/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Rendering sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */



#include "stacks2d.h"

void R2D_InitLineProps(Render2D *sr, SFNode *node);

/*hardcoded proto loading - this is mainly used for module development and testing...*/
void R2D_InitHardcodedProto(Render2D *sr, SFNode *node)
{
	MFURL *proto_url;
	LPPROTO proto;

	void FlashShape_InitNode(Render2D *sr, SFNode *node);

	proto = Node_GetProto(node);
	if (!proto) return;

	proto_url = Proto_GetExternURLFieldPointer(proto);

	/*flash shape emulation node test */
	if (proto_url->count && proto_url->vals[0].url && !stricmp(proto_url->vals[0].url, "flashshape")) {
		FlashShape_InitNode(sr, node); 
		return;
	}
}

void R2D_NodeInit(VisualRenderer *vr, SFNode *node)
{
	Render2D *sr = (Render2D *)vr->user_priv;

	switch (Node_GetTag(node)) {
#ifdef M4_DEF_Anchor
	case TAG_Anchor: R2D_InitAnchor(sr, node); break;
#endif
#ifdef M4_DEF_Background2D
	case TAG_Background2D: R2D_InitBackground2D(sr, node); break;
#endif
#ifdef M4_DEF_Bitmap
	case TAG_Bitmap: R2D_InitBitmap(sr, node); break;
#endif
#ifdef M4_DEF_Circle
	case TAG_Circle: R2D_InitCircle(sr, node); break;
#endif
#ifdef M4_DEF_ColorTransform
	case TAG_ColorTransform: R2D_InitColorTransform(sr, node); break;
#endif
#ifdef M4_DEF_CompositeTexture2D
	case TAG_CompositeTexture2D: R2D_InitCompositeTexture2D(sr, node); break;
#endif
#ifdef M4_DEF_Curve2D
	case TAG_Curve2D: R2D_InitCurve2D(sr, node); break;
#endif
#ifdef M4_DEF_XCurve2D
	case TAG_XCurve2D: R2D_InitCurve2D(sr, node); break;
#endif
#ifdef M4_DEF_DiscSensor
	case TAG_DiscSensor: R2D_InitDiscSensor(sr, node); break;
#endif
#ifdef M4_DEF_Ellipse
	case TAG_Ellipse: R2D_InitEllipse(sr, node); break;
#endif
#ifdef M4_DEF_Group
	case TAG_Group: R2D_InitGroup(sr, node); break;
#endif
#ifdef M4_DEF_IndexedFaceSet2D
	case TAG_IndexedFaceSet2D: R2D_InitIFS2D(sr, node); break;
#endif
#ifdef M4_DEF_IndexedLineSet2D
	case TAG_IndexedLineSet2D: R2D_InitILS2D(sr, node); break;
#endif
#ifdef M4_DEF_Form
	case TAG_Form: R2D_InitForm(sr, node); break;
#endif
#ifdef M4_DEF_Layer2D
	case TAG_Layer2D: R2D_InitLayer2D(sr, node); break;
#endif
#ifdef M4_DEF_Layout
	case TAG_Layout: R2D_InitLayout(sr, node); break;
#endif
#ifdef M4_DEF_PointSet2D
	case TAG_PointSet2D: R2D_InitPointSet2D(sr, node); break;
#endif
#ifdef M4_DEF_OrderedGroup
	case TAG_OrderedGroup: R2D_InitOrderedGroup(sr, node); break;
#endif
#ifdef M4_DEF_MatteTexture
	case TAG_MatteTexture: R2D_InitMatteTexture(sr, node); break;
#endif
#ifdef M4_DEF_PlaneSensor2D
	case TAG_PlaneSensor2D: R2D_InitPlaneSensor2D(sr, node); break;
#endif
#ifdef M4_DEF_ProximitySensor2D
	case TAG_ProximitySensor2D: R2D_InitProximitySensor2D(sr, node); break;
#endif
#ifdef M4_DEF_Rectangle
	case TAG_Rectangle: R2D_InitRectangle(sr, node); break;
#endif
#ifdef M4_DEF_Shape
	case TAG_Shape: R2D_InitShape(sr, node); break;
#endif
#ifdef M4_DEF_Switch
	case TAG_Switch: R2D_InitSwitch(sr, node); break;
#endif
#ifdef M4_DEF_Text
	case TAG_Text: R2D_InitText(sr, node); break;
#endif
#ifdef M4_DEF_TouchSensor
	case TAG_TouchSensor: R2D_InitTouchSensor(sr, node); break;
#endif
#ifdef M4_DEF_Transform2D
	case TAG_Transform2D: R2D_InitTransform2D(sr, node); break;
#endif
#ifdef M4_DEF_TransformMatrix2D
	case TAG_TransformMatrix2D: R2D_InitTransformMatrix2D(sr, node); break;
#endif
#ifdef M4_DEF_Viewport
	case TAG_Viewport: R2D_InitViewport(sr, node); break;
#endif

#ifdef M4_DEF_LineProperties
	case TAG_LineProperties: R2D_InitLineProps(sr, node); break;
#endif
#ifdef M4_DEF_XLineProperties
	case TAG_XLineProperties: R2D_InitLineProps(sr, node); break;
#endif


#ifdef M4_DEF_LinearGradient
	case TAG_LinearGradient: R2D_InitLinearGradient(sr, node); break;
#endif
#ifdef M4_DEF_RadialGradient
	case TAG_RadialGradient: R2D_InitRadialGradient(sr, node); break;
#endif
#ifdef M4_DEF_PathLayout
	case TAG_PathLayout: R2D_InitPathLayout(sr, node); break;
#endif

	case TAG_ProtoNode: R2D_InitHardcodedProto(sr, node); break;
	}
}


Bool R2D_NodeChanged(VisualRenderer *vr, SFNode *byObj)
{
	Render2D *sr = (Render2D*)vr->user_priv;
	assert(byObj);

	switch (Node_GetTag(byObj)) {
#ifdef M4_DEF_Background2D
	case TAG_Background2D: R2D_Background2DModified(byObj); return 1;
#endif
#ifdef M4_DEF_MatteTexture
	case TAG_MatteTexture: R2D_MatteTextureModified(byObj); return 1;
#endif	
#ifdef M4_DEF_Layout
	case TAG_Layout: R2D_LayoutModified(byObj); return 1;
#endif	

#ifdef M4_DEF_Anchor
	case TAG_Anchor:
	{
		void Node_SetDirtyFlag(SFNode *node, u16 val);
		/*mark node as dirty - since anchor acts as a sensor, mark it as dirty as a parent node*/
		Node_SetDirtyFlag(byObj, SG_NODE_DIRTY | SG_CHILD_DIRTY);
		SR_Invalidate(sr->compositor, NULL);
	}
		return 1;
#endif	

	/*let the compositor decide what to do*/
	default: return 0;
	}
}
