/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / MP4 reader plugin
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *		
 */


#include "mp4_io.h"

void mp4_on_data(NetDownloader *dnload, char *data, u32 data_size)
{
	M4Err e;
	char sMsg[1024];
	Float perc;
	const char *local_name;
	NetClientPlugin *plug = dnload->user_cbck;
	M4Reader *read = (M4Reader *) plug->priv;

	if (dnload->error<0) {
		/*error opening service*/
		if (!read->mov) NM_OnConnect(read->service, NULL, dnload->error);
		return;
	}

	if (dnload->net_status==NM_WaitingForAck) {
		NM_OnMessage(read->service, M4OK, "Connecting...");
		return;
	}
	if (dnload->net_status==NM_Connected) {
		if (!dnload->bytes_done) NM_OnMessage(read->service, M4OK, "Connected");
		return;
	}

	perc = (Float) (100 * dnload->bytes_done) / (Float) dnload->total_size;
	sprintf(sMsg, "Download %.2f %% (%.2f kBps)", perc, dnload->bytes_per_sec/1024);
	NM_OnMessage(read->service, M4OK, sMsg);

	/*service is opened, nothing to do*/
	if (read->mov) return;

	/*try to open the service*/
	local_name = dnload->GetCacheFileName(dnload);

	if (!local_name) {
		NM_OnConnect(read->service, NULL, M4InvalidPlugin);
		return;
	}

	/*not enogh data yet*/
	if (read->missing_bytes && read->missing_bytes>data_size) {
		read->missing_bytes -= data_size;
		return;
	}
	
	e = M4_MovieOpenEx(local_name, &read->mov, &read->missing_bytes);
	switch (e) {
	case M4UncompleteFile:
		return;
	case M4OK:
		break;
	default:
		NM_OnConnect(read->service, NULL, e);
		return;
	}
	
	/*ok let's go*/
	read->time_scale = M4_GetTimeScale(read->mov);
	read->status = NM_Connected;
	NM_OnConnect(read->service, NULL, M4OK);
}


void MP4_SetupDownload(NetClientPlugin *plug, const char *url)
{
	u32 count, i;
	M4Err e;
	M4Reader *read = (M4Reader *) plug->priv;

	count = PMI_GetPluginsCount((BaseInterface *) plug);
	for (i=0; i<count; i++) {
		if (PMI_LoadInterface((BaseInterface *) plug, i, M4NETDOWNLOADER, (void **) &read->dnload)) {
			if (read->dnload->CanHandleURL(url)) break;
			PM_ShutdownInterface(read->dnload);
		}
		read->dnload = NULL;
	}
	if (!read->dnload) {
		NM_OnConnect(read->service, NULL, M4UnsupportedURL);
		read->status = NM_Unavailable;
		return;
	}

	read->dnload->user_cbck = plug;	
	read->dnload->OnData = mp4_on_data;	
	e = read->dnload->Connect(read->dnload, url, 0);
	if (e) {
		NM_OnConnect(read->service, NULL, e);
	}
	/*service confirm is done once IOD can be fetched*/
}


