/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2004
 *					All rights reserved
 *
 *  This file is part of GPAC / Osmo4 wxWidgets GUI
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 *		
 */

#ifndef _WXOSMO4_H
#define _WXOSMO4_H

#include <gpac/m4_terminal.h>

#include "wx/wxprec.h"

#ifndef WX_PRECOMP
  #include "wx/wx.h"
#endif

#include <wx/image.h>
#include <wx/listctrl.h>

class wxOsmo4App : public wxApp
{
public:
	virtual bool OnInit();
};

DECLARE_APP(wxOsmo4App)

class wxOsmo4Frame;
class GPACLogs : public wxLogWindow {
public:
    GPACLogs(wxFrame *parent) : wxLogWindow(parent, "MP4Dub Logs", FALSE, FALSE) {
		m_pMain = (wxOsmo4Frame *) parent;
	}
	virtual bool OnFrameClose(wxFrame *frame);

private:
	wxOsmo4Frame *m_pMain;
};

enum {
	// Menu commands
	FILE_OPEN = wxID_HIGHEST+1,
	FILE_OPEN_URL,
	FILE_RELOAD,
	FILE_PLAY,
	FILE_STEP,
	FILE_PROPERTIES,
	FILE_QUIT,
	VIEW_FULLSCREEN,
	VIEW_ORIGINAL,
	VIEW_AR_KEEP,
	VIEW_AR_FILL,
	VIEW_AR_43,
	VIEW_AR_169,
	VIEW_OPTIONS,
	VIEW_LOGS,
	APP_SHORTCUTS,
	APP_ABOUT,
	ID_URL_GO,
	ID_ABOUT_CLOSE,

	ID_CTRL_TIMER,
	ID_CTRL_PLAY,
	ID_CTRL_PAUSE,
	ID_CTRL_STOP,
	ID_CTRL_SLIDE,

	ID_TREE_VIEW,
	ID_OD_TIMER,
	ID_VIEW_SG,
	ID_VIEW_WI,
};

wxString get_pref_browser(LPINIFILE cfg);

class wxGPACEvent : public wxEvent
{
public:
	wxGPACEvent( wxWindow* win = (wxWindow*) NULL );
	void CopyObject( wxObject& obj ) const;
	virtual wxEvent *Clone() const;

	wxString to_url;
	M4Event m4evt;

	DECLARE_DYNAMIC_CLASS(wxGPACEvent)
};
typedef void (wxEvtHandler::*GPACEventFunction)(wxGPACEvent&);
DEFINE_EVENT_TYPE(GPAC_EVENT)

#define EVT_GPACEVENT(func) DECLARE_EVENT_TABLE_ENTRY(GPAC_EVENT, -1, -1, (wxObjectEventFunction) (wxEventFunction) (GPACEventFunction) & func, (wxObject*) NULL),


class wxOsmo4Frame : public wxFrame {
public:
    wxOsmo4Frame();
    virtual ~wxOsmo4Frame();

#ifdef WIN32
	wxString m_pExePath;
#endif

	u32 m_duration;
	wxString the_url, the_next_url;
	MPEG4CLIENT m_term;
	M4User m_client;
	Bool m_paused, m_connected;
	void CheckResume();
	Bool m_console_off, m_loop, m_stop_at_end;
	
	void OpenFile(wxString url);

	void Connect(Bool bOn); 
	void ReloadTerminal(); 
	void SetStatus(wxString str);

	void OnFilePlay(wxCommandEvent &event);
	void OnFileStep(wxCommandEvent &event);

protected:

private:
	void OnFileOpen(wxCommandEvent &event);
	void OnFileOpenURL(wxCommandEvent &event);
	void OnFileReload(wxCommandEvent &event);
	void OnFileProperties(wxCommandEvent &event);
	void OnFileQuit(wxCommandEvent &event);
	void OnFullScreen(wxCommandEvent &event);
	void OnOptions(wxCommandEvent &event);
	void OnViewARKeep(wxCommandEvent &event);
	void OnViewARFill(wxCommandEvent &event);
	void OnViewAR169(wxCommandEvent &event);
	void OnViewAR43(wxCommandEvent &event);
	void OnViewOriginal(wxCommandEvent &event);
	void OnShortcuts(wxCommandEvent &event);
	void OnAbout(wxCommandEvent &event);
	Bool LoadTerminal();
	void OnGPACEvent(wxGPACEvent &event);
	void OnTimer(wxTimerEvent& event);
	void OnStop(wxCommandEvent &event);
	void OnPause(wxCommandEvent &event);
	void OnStart(wxCommandEvent &event);
	void OnSlide(wxScrollEvent &event);
	void OnRelease(wxScrollEvent &event);
	void OnLogs(wxCommandEvent & event);
	void OnUpdateNeedsConnect(wxUpdateUIEvent &event);
	void OnUpdateFullScreen(wxUpdateUIEvent &event);
	void OnUpdateAR(wxUpdateUIEvent &event);

	DECLARE_EVENT_TABLE()


    wxMenuBar* m_pMenubar;
    wxStatusBar* m_pStatusbar;
	wxTimer *m_pTimer;
	GPACLogs *m_pLogs;

	Bool m_bGrabbed, m_bToReset;
	wxBitmapButton *m_pPlay, *m_pStop, *m_pPause;
	wxBitmap *m_pPlayBMP, *m_pPauseBMP, *m_pStopBMP;
	wxSlider *m_pProg;

	void Stop();

	u32 m_LastStatusTime;
};


#endif 

