// OptAudio.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "OptAudio.h"
#include <gpac/m4_avhw.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptAudio dialog


COptAudio::COptAudio(CWnd* pParent /*=NULL*/)
	: CDialog(COptAudio::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptAudio)
	//}}AFX_DATA_INIT
}


void COptAudio::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptAudio)
	DDX_Control(pDX, IDC_DRIVER_LIST, m_DriverList);
	DDX_Control(pDX, IDC_AUDIO_RESYNC, m_AudioResync);
	DDX_Control(pDX, IDC_AUDIO_FPS, m_AudioFPS);
	DDX_Control(pDX, IDC_SPIN_FPS, m_SpinFPS);
	DDX_Control(pDX, IDC_FORCE_AUDIO, m_ForceConfig);
	DDX_Control(pDX, IDC_SPIN_AUDIO, m_AudioSpin);
	DDX_Control(pDX, IDC_EDIT_AUDIO, m_AudioEdit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptAudio, CDialog)
	//{{AFX_MSG_MAP(COptAudio)
	ON_BN_CLICKED(IDC_FORCE_AUDIO, OnForceAudio)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptAudio message handlers

BOOL COptAudio::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_AudioSpin.SetBuddy(& m_AudioEdit);
	m_SpinFPS.SetBuddy(& m_AudioFPS);

	COsmo4 *gpac = GetApp();
	char *sOpt;
	TCHAR wTmp[500];

	sOpt = IF_GetKey(gpac->m_config, "Audio", "ForceConfig");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_ForceConfig.SetCheck(1);
	} else {
		m_ForceConfig.SetCheck(0);
	}
//	m_ForceConfig.EnableWindow(FALSE);

	sOpt = IF_GetKey(gpac->m_config, "Audio", "NumBuffers");
	if (sOpt) {
		CE_CharToWide(sOpt, wTmp);
		m_AudioEdit.SetWindowText(wTmp);
	} else {
		m_AudioEdit.SetWindowText(_T("6"));
	}
	sOpt = IF_GetKey(gpac->m_config, "Audio", "BuffersPerSecond");
	if (sOpt) {
		CE_CharToWide(sOpt, wTmp);
		m_AudioFPS.SetWindowText(wTmp);
	} else {
		m_AudioFPS.SetWindowText(_T("15"));
	}

	OnForceAudio();

	sOpt = IF_GetKey(gpac->m_config, "Audio", "NoResync");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_AudioResync.SetCheck(1);
	} else {
		m_AudioResync.SetCheck(0);
	}
	
	/*driver enum*/
	while (m_DriverList.GetCount()) m_DriverList.DeleteString(0);
	sOpt = IF_GetKey(gpac->m_config, "Audio", "DriverName");
	u32 count = PM_GetPluginsCount(gpac->m_plugins);
	void *ifce;
	s32 select = 0;
	s32 to_sel = 0;
	for (u32 i=0; i<count; i++) {
		if (!PM_LoadInterface(gpac->m_plugins, i, M4_AUDIO_OUTPUT_INTERFACE, &ifce)) continue;
		if (sOpt && !stricmp(((BaseInterface *)ifce)->plugin_name, sOpt)) select = to_sel;
		CE_CharToWide((char *) ((BaseInterface *)ifce)->plugin_name, wTmp);
		m_DriverList.AddString(wTmp);
		PM_ShutdownInterface(ifce);
		to_sel++;
	}
	m_DriverList.SetCurSel(select);
	
	
	return TRUE;  
}


void COptAudio::SaveOptions()
{
	COsmo4 *gpac = GetApp();
	TCHAR wstr[50];
	char str[50];

	IF_SetKey(gpac->m_config, "Audio", "ForceConfig", m_ForceConfig.GetCheck() ? "yes" : "no");
	IF_SetKey(gpac->m_config, "Audio", "NoResync", m_AudioResync.GetCheck() ? "yes" : "no");

	m_AudioEdit.GetWindowText(wstr, 20);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "Audio", "NumBuffers", str);
	m_AudioFPS.GetWindowText(wstr, 20);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "Audio", "BuffersPerSecond", str);

	m_DriverList.GetWindowText(wstr, 50);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "Audio", "DriverName", str);

}

void COptAudio::OnForceAudio() 
{
	BOOL en = m_ForceConfig.GetCheck();

	m_AudioSpin.EnableWindow(en);
	m_AudioEdit.EnableWindow(en);
	m_SpinFPS.EnableWindow(en);
	m_AudioFPS.EnableWindow(en);
}
