// FileProps.cpp : implementation file
//

#include "stdafx.h"
#include "osmo4.h"
#include "FileProps.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileProps dialog


CFileProps::CFileProps(CWnd* pParent /*=NULL*/)
	: CDialog(CFileProps::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileProps)
	//}}AFX_DATA_INIT
}


void CFileProps::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileProps)
	DDX_Control(pDX, IDC_OBJECT_TIME, m_ObjectTime);
	DDX_Control(pDX, IDC_ODINFO, m_ODInfo);
	DDX_Control(pDX, IDC_ODTREE, m_ODTree);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileProps, CDialog)
	//{{AFX_MSG_MAP(CFileProps)
	ON_NOTIFY(TVN_SELCHANGED, IDC_ODTREE, OnSelchangedOdtree)
	ON_BN_CLICKED(IDC_WORLD, OnWorld)
	ON_BN_CLICKED(IDC_VIEWSG, OnViewsg)
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileProps message handlers


#define FP_TIMER_ID	20

BOOL CFileProps::OnInitDialog() 
{
	CDialog::OnInitDialog();

	char sText[5000];
	sprintf(sText, "%s Properties", GetApp()->m_filename);
	SetWindowText(sText);
	current_odm = NULL;
	m_ODTree.SetIndent(0);
	RewriteODTree();
	SetTimer(FP_TIMER_ID, 500, NULL);
	return TRUE;
}


void CFileProps::WriteInlineTree(LPODMANAGER root_od, HTREEITEM parent)
{
	ODInfo info;
	WinGPAC *gpac = GetApp();

	/*browse all ODs*/
	u32 count = M4T_GetODCount(gpac->m_term, root_od);

	for (u32 i=0; i<count; i++) {
		LPODMANAGER odm = M4T_GetODManager(gpac->m_term, root_od, i);
		if (!odm) return;
		HTREEITEM item = m_ODTree.InsertItem("Object Descriptor", 0, 0, parent);
		m_ODTree.SetItemData(item, (DWORD) odm);
		/*browse all remotes*/
		while (1) {
			LPODMANAGER remote = M4T_GetRemoteOD(gpac->m_term, odm);
			if (!remote) break;
			if (M4T_GetODInfo(gpac->m_term, odm, &info) != M4OK) break;
			char sText[5000];
			sprintf(sText, "Remote OD (%s)", info.od->URLString);
			
			m_ODTree.SetItemText(item, sText);
			item = m_ODTree.InsertItem("Object Descriptor", 0, 0, item);
			m_ODTree.SetItemData(item, (DWORD) remote);
			odm = remote;
		}
		/*if inline propagate*/
		switch (M4T_IsInlineOD(gpac->m_term, odm)) {
		case 1:
			m_ODTree.SetItemText(item, "Inline Scene");
			WriteInlineTree(odm, item);
			break;
		case 2:
			m_ODTree.SetItemText(item, "Extern Proto Lib");
			WriteInlineTree(odm, item);
			break;
		default:
			break;
		}
	}
}

void CFileProps::RewriteODTree()
{
	ODInfo info;
	WinGPAC *gpac = GetApp();
	
	m_ODTree.DeleteAllItems();

	LPODMANAGER root_odm = M4T_GetRootOD(gpac->m_term);
	if (!root_odm) return;

	HTREEITEM root = m_ODTree.InsertItem("Root OD", 0, 0);
	m_ODTree.SetItemData(root, (DWORD) root_odm);

	/*browse all remotes*/
	while (1) {
		LPODMANAGER remote = M4T_GetRemoteOD(gpac->m_term, root_odm);
		if (!remote) break;
		if (M4T_GetODInfo(gpac->m_term, root_odm, &info) != M4OK) break;
		char sText[5000];
		sprintf(sText, "Remote OD (%s)", info.od->URLString);
		m_ODTree.SetItemText(root, sText);

		root = m_ODTree.InsertItem("Object Descriptor", 0, 0, root);
		m_ODTree.SetItemData(root, (DWORD) remote);
		root_odm = remote;
	}

	m_ODTree.SetItemText(root, "Inline Scene");
	WriteInlineTree(root_odm, root);
}

void CFileProps::OnSelchangedOdtree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	*pResult = 0;
	
	HTREEITEM item = m_ODTree.GetSelectedItem();
	LPODMANAGER odm = (LPODMANAGER) m_ODTree.GetItemData(item);
	if (!odm) return;
	
	SetODInfo(odm);
}

void CFileProps::SetODInfo(LPODMANAGER odm)
{
	char info[10000];
	char buf[1000];
	ODInfo odi;
	Bool is_media;
	u32 h, m, s;

	WinGPAC *gpac = GetApp();

	strcpy(info, "");
	if (M4T_GetODInfo(gpac->m_term, odm, &odi) != M4OK) return;

	current_odm = odm;

	m_OD_ID = odi.od->objectDescriptorID;

	if (odi.has_profiles) {
		sprintf(buf, "Initial Object Descriptor ID %d - ", odi.od->objectDescriptorID);
		strcat(info, buf);
		if (odi.duration) {
			h = (u32) (odi.duration / 3600);
			m = (u32) (odi.duration / 60) - h*60;
			s = (u32) (odi.duration) - h*3600 - m*60;
			sprintf(buf, "Duration %02d:%02d:%02d\r\n", h, m, s);
			strcat(info, buf);
		} else {
			strcat(info, "Unknown duration\r\n");
		}
		sprintf(buf, "\tOD Profile@Level %d\r\n", odi.OD_pl);
		strcat(info, buf);
		sprintf(buf, "\tScene Profile@Level %d\r\n", odi.scene_pl);
		strcat(info, buf);
		sprintf(buf, "\tGraphics Profile@Level %d\r\n", odi.graphics_pl);
		strcat(info, buf);
		sprintf(buf, "\tAudio Profile@Level %d\r\n", odi.audio_pl);
		strcat(info, buf);
		sprintf(buf, "\tVisual Profile@Level %d\r\n", odi.scene_pl);
		strcat(info, buf);
		sprintf(buf, "\tInline Content Profiled %s\r\n", odi.inline_pl ? "yes" : "no");
		strcat(info, buf);
		strcat(info, "\r\n");
	} else {
		sprintf(buf, "Object Descriptor ID %d - ", odi.od->objectDescriptorID);
		strcat(info, buf);
		if (odi.duration) {
			h = (u32) (odi.duration / 3600);
			m = (u32) (odi.duration / 60) - h*60;
			s = (u32) (odi.duration) - h*3600 - m*60;
			sprintf(buf, "Duration %02d:%02d:%02d\r\n", h, m, s);
			strcat(info, buf);
		} else {
			strcat(info, "Unknown duration\r\n");
		}
	}

	if (odi.owns_service) {
		strcat(info, "Service Handler: ");
		strcat(info, odi.service_handler);
		strcat(info, "\r\n");
		strcat(info, "Service URL: ");
		strcat(info, odi.service_url);
		strcat(info, "\r\n");
	}
	
	if (odi.od->URLString) {
		strcat(info, "Remote OD - URL: ");
		strcat(info, odi.od->URLString);
		strcat(info, "\r\n");
		goto common;
	} 
	SetODTime();

	strcat(info, "\r\n");
	if (odi.codec_name) {
		switch (odi.od_type) {
		case M4ST_VISUAL:
			sprintf(buf, "Video Object: Width %d - Height %d\r\n", odi.width, odi.height);
			strcat(info, buf);
			break;
		case M4ST_AUDIO:
			sprintf(buf, "Audio Object: Sample Rate %d - %d channels\r\n", odi.sample_rate, odi.num_channels);
			strcat(info, buf);
			break;
		}
		strcat(info, "Media Codec ");
		strcat(info, odi.codec_name);
		strcat(info, "\r\n");
	}
	strcat(info, "\r\n");

	/*dump ES info*/
	u32 count;
	is_media = 0;
	count = ChainGetCount(odi.od->ESDescriptors);
	u32 i, j;
	sprintf(buf, "%d streams in object\r\n", count);
	for (i=0; i<count; i++) {
		ESDescriptor *esd = (ESDescriptor *) ChainGetEntry(odi.od->ESDescriptors, i);

		sprintf(buf, "Stream ID %d - Clock ID %d\r\n", esd->ESID, esd->OCRESID);
		strcat(info, buf);
		if (esd->dependsOnESID) {
			sprintf(buf, "\tDepends on Stream ID %d for decoding\r\n", esd->dependsOnESID);
			strcat(info, buf);
		}
		switch (esd->decoderConfig->streamType) {
		case M4ST_OD:
			sprintf(buf, "\tOD Stream - version %d\r\n", esd->decoderConfig->objectTypeIndication);
			strcat(info, buf);
			break;
		case M4ST_OCR:
			sprintf(buf, "\tOCR Stream\r\n");
			strcat(info, buf);
			break;
		case M4ST_BIFS:
			sprintf(buf, "\tBIFS Stream - version %d\r\n", esd->decoderConfig->objectTypeIndication);
			strcat(info, buf);
			break;
		case M4ST_VISUAL:
			is_media = 1;
			strcat(info, "\tVisual Stream - media type: ");
			switch (esd->decoderConfig->objectTypeIndication) {
			case 0x20:
				strcat(info, "MPEG-4\r\n");
				break;
			case 0x60:
				strcat(info, "MPEG-2 Simple Profile\r\n");
				break;
			case 0x61:
				strcat(info, "MPEG-2 Main Profile\r\n");
				break;
			case 0x62:
				strcat(info, "MPEG-2 SNR Profile\r\n");
				break;
			case 0x63:
				strcat(info, "MPEG-2 Spatial Profile\r\n");
				break;
			case 0x64:
				strcat(info, "MPEG-2 High Profile\r\n");
				break;
			case 0x65:
				strcat(info, "MPEG-2 422 Profile\r\n");
				break;
			case 0x6A:
				strcat(info, "MPEG-1\r\n");
				break;
			case 0x6C:
				strcat(info, "JPEG\r\n");
				break;
			case 0x6D:
				strcat(info, "PNG\r\n");
				break;
			default:
				strcat(info, "Private Type\r\n");
				break;
			}
			break;

		case M4ST_AUDIO:
			is_media = 1;
			strcat(info, "\tAudio Stream - media type: ");
			switch (esd->decoderConfig->objectTypeIndication) {
			case 0x40:
				strcat(info, "MPEG-4\r\n");
				break;
			case 0x66:
				strcat(info, "MPEG-2 AAC Main Profile\r\n");
				break;
			case 0x67:
				strcat(info, "MPEG-2 AAC LowComplexity Profile\r\n");
				break;
			case 0x68:
				strcat(info, "MPEG-2 AAC Scalable Sampling Rate Profile\r\n");
				break;
			case 0x69:
			case 0x6B:
				strcat(info, "MPEG-1 / MPEG-2 Audio\r\n");
				break;
			default:
				strcat(info, "Private/Unknown\r\n");
				break;
			}
			break;
		case M4ST_MPEG7:
			sprintf(buf, "\tMPEG-7 Stream - version %d\r\n", esd->decoderConfig->objectTypeIndication);
			strcat(info, buf);
			break;
		case M4ST_IPMP:
			sprintf(buf, "\tIPMP Stream - version %d\r\n", esd->decoderConfig->objectTypeIndication);
			strcat(info, buf);
			break;
		case M4ST_OCI:
			sprintf(buf, "\tOCI Stream - version %d\r\n", esd->decoderConfig->objectTypeIndication);
			strcat(info, buf);
			break;
		case M4ST_MPEGJ:
			sprintf(buf, "\tMPEGJ Stream - version %d\r\n", esd->decoderConfig->objectTypeIndication);
			strcat(info, buf);
			break;
		case M4ST_INTERACT:
			sprintf(buf, "\tUser Interaction Stream - version %d\r\n", esd->decoderConfig->objectTypeIndication);
			strcat(info, buf);
			break;
		default:
			sprintf(buf, "Private/Unknown\r\n");
			strcat(info, buf);
			break;
		}

		sprintf(buf, "\tBuffer Size %d\r\n\tAverage Bitrate %d bps\r\n\tMaximum Bitrate %d bps\r\n", esd->decoderConfig->bufferSizeDB, esd->decoderConfig->avgBitrate, esd->decoderConfig->maxBitrate);
		strcat(info, buf);
		sprintf(buf, "\tStream Clock Resolution %d\r\n", esd->slConfig->timestampResolution);
		strcat(info, buf);
		if (esd->URLString) {
			sprintf(buf, "\tStream Location: %s\r\n", esd->URLString);
			strcat(info, buf);
		}

		/*check language*/
		if (ChainGetCount(esd->langDesc)) {
			LanguageDescriptor *ld = (LanguageDescriptor *)ChainGetEntry(esd->langDesc, 0);
			ld->langCode;
			sprintf(buf, "\tStream Language: %c%c%c\r\n", (char) ((ld->langCode>>16)&0xFF), (char) ((ld->langCode>>8)&0xFF), (char) (ld->langCode & 0xFF) );
			strcat(info, buf);
		}

	}
	

common:

	/*check OCI (not everything interests us) - FIXME: support for unicode*/
	for (i=0; i<ChainGetCount(odi.od->OCIDescriptors); i++) {
		Descriptor *desc = (Descriptor *) ChainGetEntry(odi.od->OCIDescriptors, i);
		switch (desc->tag) {
		case SegmentDescriptor_Tag:
		{
			SegmentDescriptor *sd = (SegmentDescriptor *) desc;
			strcat(info, "\r\nSegment Descriptor:\r\n");
			sprintf(buf, "Name: %s - start time %g sec - duration %g sec\r\n", sd->SegmentName, sd->startTime, sd->Duration);
			strcat(info, buf);
		}
			break;
		case ContentCreatorName_Tag:
		{
			ContentCreatorNameDescriptor *ccn = (ContentCreatorNameDescriptor *)desc;
			strcat(info, "\r\nContent Creators:\r\n");
			for (j=0; j<ChainGetCount(ccn->ContentCreators); j++) {
				contentCreatorInfo *ci = (contentCreatorInfo *) ChainGetEntry(ccn->ContentCreators, j);
				if (!ci->isUTF8) continue;
				strcat(info, "\t");
				strcat(info, ci->contentCreatorName);
				strcat(info, "\r\n");
			}
		}
			break;

		case ShortTextualDescriptor_Tag:
			{
				ShortTextualDescriptor *std = (ShortTextualDescriptor *)desc;
				strcat(info, "\r\n");
				strcat(info, std->eventName);
				strcat(info, ": ");
				strcat(info, std->eventText);
				strcat(info, "\r\n");
			}
			break;
		/*todo*/
		case ContentCreationDate_Tag:
			break;
		default:
			break;
		}

	}

	m_ODInfo.SetWindowText(info);
}

void CFileProps::OnWorld() 
{
#ifdef M4_DEF_WorldInfo
	CString wit;
	WinGPAC *gpac = GetApp();
	B_WorldInfo *wi = M4T_GetWorldInfo(gpac->m_term, current_odm);
	if (!wi) {
		MessageBox("No World Info available", "Sorry!");
		return;
	}

	wit = "";
	for (u32 i=0; i<wi->info.count; i++) {
		wit += wi->info.vals[i];
		wit += "\n";
	}
	MessageBox(wit, (const char *) wi->title.buffer);
#else
		MessageBox("Sorry!", "World Info support not built-in");
#endif
}

void CFileProps::OnViewsg() 
{
	CString out_file;
	WinGPAC *gpac = GetApp();

	out_file = gpac->m_config_dir;
	if (gpac->m_ViewXMTA) {
		out_file += "scene_dump.xml";
	} else {
		out_file += "scene_dump.bt";
	}
	FILE *dump = fopen(out_file, "wt");
	if (!dump) {
		MessageBox("Cannot open temporary dump file", "Error");
		return;
	}

	M4Err e = M4T_DumpSceneGraph(gpac->m_term, dump, gpac->m_ViewXMTA, 0, current_odm);
	fclose(dump);
	if (e) {
		MessageBox(M4ErrToString(e), "Error while dumping");
	} else {
		ShellExecute(NULL, "open", (LPCSTR) out_file, NULL, NULL, SW_SHOWNORMAL);
	}
}


void CFileProps::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == FP_TIMER_ID) SetODTime();
	
	CDialog::OnTimer(nIDEvent);
}

void CFileProps::SetODTime()
{
	ODInfo odi;
	char buf[1000], info[2000];
	u32 h, m, s;

	if (!current_odm) {
		m_ObjectTime.SetWindowText("");
		return;
	}
	WinGPAC *gpac = GetApp();

	if (M4T_GetODInfo(gpac->m_term, current_odm, &odi)) return;

	sprintf(info, "");
	switch (odi.status) {
	case 1:
		h = (u32) (odi.current_time / 3600);
		m = (u32) (odi.current_time / 60) - h*60;
		s = (u32) (odi.current_time) - h*3600 - m*60;
		sprintf(buf, "Playing %02d:%02d:%02d", h, m, s);
		strcat(info, buf);
		break;
	case 2:
		strcat(info, "Paused");
		break;
	default:
		strcat(info, "Stoped");
		break;
	}
	/*get buffering*/
	if (odi.buffer>=0) {
		sprintf(buf, " - Buffer: %d ms", odi.buffer);
		strcat(info, buf);
	} else if (odi.buffer==-1) {
		strcat(info, " - Not buffering");
	} else {
		strcat(info, " - Not Playing");
	}
	/*get clock drift*/
	sprintf(buf, " - Clock drift: %d ms\r\n", odi.clock_drift);
	strcat(info, buf);
	/*get DB occupation*/
	if (odi.buffer>=0) {
		sprintf(buf, "Decoding Buffer: %d Units\r\n", odi.db_unit_count);
		strcat(info, buf);
	}
	/*get CB occupation*/
	if (odi.cb_max_count) {
		sprintf(buf, "Composition Memory: %d Units (%d max)", odi.cb_unit_count, odi.cb_max_count);
		strcat(info, buf);
	}
	m_ObjectTime.SetWindowText(info);
}

void CFileProps::OnClose() 
{
	KillTimer(FP_TIMER_ID);
	DestroyWindow();
}

void CFileProps::OnDestroy() 
{
	CDialog::OnDestroy();
	delete this;
	((CMainFrame *)GetApp()->m_pMainWnd)->m_pProps = NULL;
}
