/* $Id: goby.h 34469 2011-01-29 00:27:09Z twu $ */
#ifndef GOBY_INCLUDED
#define GOBY_INCLUDED

#include "bool.h"
#include "iit-read.h"
#include "shortread.h"
#include "stage3hr.h"

typedef struct Gobyreader_T *Gobyreader_T;
typedef struct Gobywriter_T *Gobywriter_T;

extern void
Goby_shutdown ();
extern void
Goby_reader_free (Gobyreader_T *old);
extern Gobyreader_T
Goby_reader_new (char **files, int nfiles, unsigned long window_start, unsigned long window_end);
extern Shortread_T
Goby_read (Shortread_T *queryseq2, Gobyreader_T reader, int barcode_length,
	   bool invert_first_p, bool invert_second_p);
extern void
Goby_reader_finish (Gobyreader_T reader);

extern void
Goby_writer_free (Gobywriter_T *old);
extern Gobywriter_T
Goby_writer_new (char *output_root, char *aligner_name, char *aligner_version);
extern void
Goby_writer_add_chromosomes (Gobywriter_T writer, IIT_T chromosome_iit);
extern void
Goby_print_single (Gobywriter_T writer, Stage3_T *stage3array, Shortread_T queryseq1,
		   int npaths, int maxpaths, bool quiet_if_excessive_p);
extern void
Goby_writer_finish (Gobywriter_T writer, Gobyreader_T reader);

#endif

