/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * @(#) ApplicationLoaderEventListener.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
package com.sun.enterprise.server.event;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.Application;

/**
 *
 * ApplicationEvents are sent before/after an application
 *  is loaded/unloaded.
 *
 * Listeners that are interested in getting ApplicationLaoderEvents
 *  can register with the ApplicationLoaderEventNotifier as follows:
 *
 *  ApplicationLoaderEventNotifier notifier =
 *	ApplicationLoaderEventNotifier.getInstance();
 *  notifier.addListener(listener);
 *
 * Application events are sent even when StandaloneModules are
 *  deployed / undeployed. ApplicationEvent.getApplication().isVirtual()
 *  will return true for stand-alone modules and false otherwise.
 *
 * Generally, APPLICATION events are sent in the following order
 *  a) BEFORE_APPLICATION_LOADED
 *  b) AFTER_APPLICATION_LOADED
 *  c) BEFORE_APPLICATION_UNLOADED
 *  d) AFTER_APPLICATION_UNLOADED
 *
 * Note:-
 *  There are some cases, when AFTER_APPLICATION_LOADED and 
 *  BEFORE_APPLICATION_UNLOAD will not be sent to listeners. 
 *  In particular, if an Ejb cannot be loaded successfully
 *  then no AFTER_APPLICATION_LOADED and BEFORE_APPLICATION_UNLOAD
 *  will be sent to the listeners.
 *  
 */

public class ApplicationEvent {

    public static final int BEFORE_APPLICATION_LOAD = 0;
    public static final int AFTER_APPLICATION_LOAD = 1;
    public static final int BEFORE_APPLICATION_UNLOAD = 2;
    public static final int AFTER_APPLICATION_UNLOAD = 3;

    private int		eventType;
    private Application application;
    private ClassLoader	loader;
    private ConfigContext configContext;

    public ApplicationEvent(int eventType, Application application,
	    ClassLoader loader, ConfigContext configContext)
    {
	this.eventType = eventType;
	this.application = application;
	this.loader = loader;
        this.configContext = configContext;
    }
    
    public int getEventType() {
	return this.eventType;
    }

    public Application getApplication() {
	return this.application;
    }

    public ClassLoader getClassLoader() {
	return this.loader;
    }
    
    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer("AppEvent: ");
        return toString(sbuf);
    }
    
    /**
     *Appends event info to the already-instantiated StringBuffer argument.
     *@param StringBuffer already created and, optionally, already containing
     *a prefix identfying which type of event this is.
     */
    protected String toString(StringBuffer sbuf) {
	switch (eventType) {
	    case BEFORE_APPLICATION_LOAD:
		sbuf.append("BEFORE_LOAD -> ");
		break;
	    case AFTER_APPLICATION_LOAD:
		sbuf.append("AFTER_LOAD -> ");
		break;
	    case BEFORE_APPLICATION_UNLOAD:
		sbuf.append("BEFORE_UNLOAD -> ");
		break;
	    case AFTER_APPLICATION_UNLOAD:
		sbuf.append("AFTER_UNLOAD -> ");
		break;
	    default:
		//
	}

	if (application != null) {
	    sbuf.append(application.getRegistrationName());
	}
	return sbuf.toString();
    }

}
