/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl2.impl;

import com.sun.jbi.wsdl2.Definitions;
import com.sun.jbi.wsdl2.Description;
import com.sun.jbi.wsdl2.WsdlException;
import com.sun.jbi.wsdl2.impl.DOMUtilities;
import com.sun.jbi.wsdl2.impl.DescriptionImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.w3.x2006.x01.wsdl.DescriptionDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

final class WsdlReader
implements com.sun.jbi.wsdl2.WsdlReader {
    private final Logger mLogger = Logger.getLogger("com.sun.jbi.wsdl2.logger");

    WsdlReader() {
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    public Description readDescription(String wsdlUri) throws WsdlException, MalformedURLException, IOException {
        return this.readDescription(null, wsdlUri);
    }

    public Definitions readWsdl(String wsdlURI) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(wsdlURI);
    }

    public Description readDescription(String contextUri, String wsdlUri) throws WsdlException, MalformedURLException, IOException {
        Object result = null;
        URL contextURL = contextUri != null ? WsdlReader.getURL(null, contextUri) : null;
        URL wsdlURL = WsdlReader.getURL(contextURL, wsdlUri);
        DescriptionDocument defDoc = null;
        try {
            defDoc = DescriptionDocument.Factory.parse(wsdlURL);
            WsdlReader.validate(defDoc);
        }
        catch (XmlException ex) {
            throw new WsdlException(ex.getMessage());
        }
        return DescriptionImpl.Factory.getInstance(defDoc, wsdlURL.toExternalForm());
    }

    public Definitions readWsdl(String contextURI, String wsdlURI) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(contextURI, wsdlURI);
    }

    private static void validate(DescriptionDocument defDoc) throws WsdlException {
        XmlOptions validateOptions = new XmlOptions();
        ArrayList errorList = new ArrayList();
        validateOptions.setErrorListener(errorList);
        boolean isValid = defDoc.validate(validateOptions);
        if (!isValid) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                XmlError error = (XmlError)errorList.get(i);
                if (i > 0) {
                    sb.append("\n\n");
                }
                sb.append("Message: ");
                sb.append(error.getMessage());
                sb.append("\n");
                sb.append("Location of invalid XML: ");
                sb.append(error.getCursorLocation().xmlText());
                sb.append("\n\n");
            }
            throw new WsdlException(sb.toString());
        }
    }

    public Description readDescription(String documentBaseUri, Document document) throws WsdlException {
        return this.readDescription(documentBaseUri, document.getDocumentElement());
    }

    public Definitions readWsdl(String documentBaseURI, Document document) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(documentBaseURI, document);
    }

    public Description readDescription(String documentBaseUri, Element element) throws WsdlException {
        DescriptionDocument defDoc;
        try {
            defDoc = DescriptionDocument.Factory.parse(element);
            WsdlReader.validate(defDoc);
        }
        catch (XmlException ex) {
            throw new WsdlException(ex.getMessage());
        }
        return DescriptionImpl.Factory.getInstance(defDoc, documentBaseUri);
    }

    public Definitions readWsdl(String documentBaseURI, Element definitionsElement) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(documentBaseURI, definitionsElement);
    }

    public Description readDescription(String documentBaseURI, InputSource inputSource) throws WsdlException, IOException {
        return this.readDescription(documentBaseURI, DOMUtilities.getDocument(documentBaseURI, inputSource));
    }

    public Definitions readWsdl(String documentBaseURI, InputSource inputSource) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(documentBaseURI, inputSource);
    }

    static URL getURL(URL contextURL, String specification) throws MalformedURLException {
        File tempFile;
        if (contextURL != null && (tempFile = new File(specification)).isAbsolute()) {
            return tempFile.toURL();
        }
        try {
            return new URL(contextURL, specification);
        }
        catch (MalformedURLException e) {
            if (contextURL == null) {
                return new File(specification).toURL();
            }
            throw e;
        }
    }
}

