/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.util.jmx;

import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.HandshakeCompletedListenerImpl;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.client.TrustStoreTrustManager;
import com.sun.jbi.util.StringTranslator;
import com.sun.jbi.util.jmx.JMXConnectorSource;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.X509TrustManager;

public class AppSrvJMXConnectorSource
implements JMXConnectorSource {
    private String mUser = null;
    private String mPwd = null;
    private JMXServiceURL mJmxServiceUrl = null;
    private JMXConnector mJmxConnector = null;
    private boolean mIsSecure = false;
    private TLSParams mTlsParams;
    private String mHost = null;
    private int mPort = 0;
    private static final String NULL_OBJECT = "NULL_OBJECT";
    private static final String DEFAULT_STORE_TYPE = "JKS";

    public void setCredentials(String username, String password) {
        this.mUser = username;
        this.mPwd = password;
    }

    public void setIsSecure(boolean secureFlag) {
        this.mIsSecure = secureFlag;
    }

    public void setTrustStore(File truststore, String type, char[] passwd) {
        if (type == null) {
            type = DEFAULT_STORE_TYPE;
        }
        TrustStoreTrustManager trustMgr = new TrustStoreTrustManager(truststore, type, passwd);
        trustMgr.setPrompt(true);
        HandshakeCompletedListenerImpl listener = new HandshakeCompletedListenerImpl();
        this.mTlsParams = new TLSParams(new X509TrustManager[]{trustMgr}, (HandshakeCompletedListener)listener);
    }

    public void setJMXServiceURL(JMXServiceURL jmxServiceURL) {
        this.mJmxServiceUrl = jmxServiceURL;
        if (this.mJmxServiceUrl != null && this.mJmxServiceUrl.getHost() != null && this.mJmxServiceUrl.getPort() != 0) {
            this.mHost = this.mJmxServiceUrl.getHost();
            this.mPort = this.mJmxServiceUrl.getPort();
        }
    }

    public void setHostAndPort(String host, int port) {
        this.mHost = host;
        this.mPort = port;
    }

    public JMXConnector getJMXConnector(boolean forceNew, Map environment) throws IOException {
        StringTranslator translator = new StringTranslator("com.sun.jbi.util", null);
        if (this.mHost == null || this.mPort == 0) {
            throw new IOException(translator.getString(NULL_OBJECT, "JMX Connector Server Host/Port"));
        }
        if (this.mUser == null || this.mPwd == null) {
            throw new IOException(translator.getString(NULL_OBJECT, "Username/Password"));
        }
        if (this.mJmxConnector == null || forceNew) {
            AppserverConnectionSource src = null;
            if (this.mIsSecure) {
                System.out.println("Connecting using TLS Params.");
                src = new AppserverConnectionSource("sun-as-rmi", this.mHost, this.mPort, this.mUser, this.mPwd, this.mTlsParams, environment);
            } else {
                src = new AppserverConnectionSource("sun-as-rmi", this.mHost, this.mPort, this.mUser, this.mPwd, null, environment);
            }
            this.mJmxConnector = src.getJMXConnector(forceNew);
        }
        return this.mJmxConnector;
    }
}

