/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.MessageFactory;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.messaging.util.Translator;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Transaction;
import javax.xml.namespace.QName;

public class MessageExchangeImpl
implements MessageExchange,
Cloneable {
    private static final int MAX_ID = 99999999;
    private static MessageFactory sMsgFac = MessageFactory.getInstance();
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private QName mService;
    private QName mInterfaceName;
    private ServiceEndpoint mEndpoint;
    private QName mOperation;
    private Fault mFault;
    private HashMap mMessages;
    private HashMap mProperties;
    private HashMap mDeltaProperties;
    private String mExchangeId;
    private ExchangeStatus mStatus;
    private Exception mError;
    private Object mTransaction;
    private boolean mAutoSuspendResume;
    private MessageExchangeProxy mSource;
    private MessageService mMsgSvc;
    private boolean mRemote;

    MessageExchangeImpl(MessageExchangeProxy proxy, MessageService msgSvc) {
        this.mMsgSvc = msgSvc;
        this.mSource = proxy;
        this.mAutoSuspendResume = false;
        proxy.setMessageExchange(this);
        this.init();
    }

    private void init() {
        this.mExchangeId = this.mMsgSvc.generateNextId();
        this.mProperties = new HashMap();
        this.mDeltaProperties = new HashMap();
        this.mMessages = new HashMap();
        this.mStatus = ExchangeStatus.ACTIVE;
        this.mRemote = false;
    }

    public Fault createFault() throws MessagingException {
        return sMsgFac.createFault();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return sMsgFac.createMessage();
    }

    public ServiceEndpoint getEndpoint() {
        return this.mEndpoint;
    }

    public Exception getError() {
        return this.mError;
    }

    public String getExchangeId() {
        return this.mExchangeId;
    }

    public Fault getFault() {
        return this.mFault;
    }

    public NormalizedMessage getMessage(String name) {
        return (NormalizedMessage)this.mMessages.get(name);
    }

    public QName getOperation() {
        return this.mOperation;
    }

    public URI getPattern() {
        return this.mSource == null ? null : this.mSource.getPattern();
    }

    public Object getProperty(String name) {
        Object prop = this.mDeltaProperties.get(name);
        if (prop == null) {
            prop = this.mProperties.get(name);
        }
        return prop;
    }

    public Set getPropertyNames() {
        Set names = this.mProperties.keySet();
        names.addAll(this.mDeltaProperties.keySet());
        return names;
    }

    public MessageExchange.Role getRole() {
        return null;
    }

    public QName getService() {
        return this.mService;
    }

    public ExchangeStatus getStatus() {
        return this.mStatus;
    }

    Set getDeltaProperties() {
        return this.mDeltaProperties.entrySet();
    }

    void setExchangeId(String id) {
        this.mExchangeId = id;
        this.mRemote = true;
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.mEndpoint = endpoint;
    }

    public void setError(Exception error) {
        this.mError = error;
    }

    public void setFault(Fault fault) {
        this.mFault = fault;
    }

    public void setMessage(NormalizedMessage msg, String name) {
        if (msg == null) {
            this.mMessages.remove(name);
        } else {
            this.mMessages.put(name, msg);
        }
    }

    public void setOperation(QName name) {
        this.mOperation = name;
    }

    public void setProperty(String name, Object obj) {
        if (name.equals("javax.jbi.transaction.jta")) {
            try {
                this.setTransactionContext((Transaction)obj);
            }
            catch (MessagingException msgEx) {
                this.mLog.warning(msgEx.toString());
            }
        }
        this.mDeltaProperties.put(name, obj);
    }

    public void mergeProperties() {
        this.mProperties.putAll(this.mDeltaProperties);
        this.mDeltaProperties.clear();
    }

    boolean isRemote() {
        return this.mRemote;
    }

    public void setService(QName service) {
        this.mService = service;
    }

    public void setStatus(ExchangeStatus status) {
        this.mStatus = status;
    }

    public QName getInterfaceName() {
        return this.mInterfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.mInterfaceName = interfaceName;
    }

    void setTransactionContext(Transaction xact) throws MessagingException {
        if (xact == null) {
            try {
                xact = this.mMsgSvc.getTransactionManager().getTransaction();
            }
            catch (Exception ex) {
                throw new MessagingException(Translator.translate("CANT_GET_DEFAULT_TRANSACTION"));
            }
        }
        this.mTransaction = xact;
    }

    public Transaction getTransactionContext() {
        return (Transaction)this.mTransaction;
    }

    public boolean isTransacted() {
        return this.mTransaction != null;
    }

    MessageExchangeProxy getSource() {
        return this.mSource;
    }

    void suspendTX() throws MessagingException {
        if (this.mTransaction != null) {
            try {
                if (this.mAutoSuspendResume) {
                    this.mLog.fine(Translator.translate("EXCHANGE_SUSPEND_TX", new Object[]{this.mExchangeId}));
                    if (this.mTransaction == this.mMsgSvc.getTransactionManager().getTransaction()) {
                        this.mMsgSvc.getTransactionManager().suspend();
                    }
                } else if (this.mMsgSvc.getTransactionManager().getTransaction() == this.mTransaction) {
                    throw new MessagingException(Translator.translate("MUST_SUSPEND"));
                }
            }
            catch (Exception ex) {
                throw new MessagingException(Translator.translate("CANT_SUSPEND"));
            }
        }
    }

    void resumeTX() throws MessagingException {
        if (this.mTransaction != null && this.mAutoSuspendResume) {
            try {
                this.mLog.fine(Translator.translate("EXCHANGE_RESUME_TX", new Object[]{this.mExchangeId}));
                this.mMsgSvc.getTransactionManager().resume((Transaction)this.mTransaction);
            }
            catch (InvalidTransactionException ite) {
                throw new MessagingException(Translator.translate("CANT_RESUME_INVALID"));
            }
            catch (Exception ex) {
                throw new MessagingException(Translator.translate("CANT_RESUME"));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n        Status: ");
        sb.append(this.mStatus.equals(ExchangeStatus.ACTIVE) ? "ACTIVE" : (this.mStatus.equals(ExchangeStatus.DONE) ? "DONE" : "ERROR"));
        sb.append("  Location: ");
        sb.append(this.mRemote ? "REMOTE" : "LOCAL");
        sb.append("\n        Service: ");
        sb.append(this.mService);
        sb.append("\n");
        sb.append(this.mEndpoint);
        sb.append("        Operation:     ");
        sb.append(this.mOperation == null ? "null" : this.mOperation);
        sb.append("\n        InterfaceName: ");
        sb.append(this.mInterfaceName == null ? "null" : this.mInterfaceName);
        sb.append("\n        Transaction:   ");
        sb.append(this.mTransaction == null ? "None" : this.mTransaction.toString());
        sb.append("\n        Properties Count: ");
        sb.append(this.mProperties.size());
        sb.append("\n");
        for (Map.Entry me : this.mProperties.entrySet()) {
            sb.append("          Name: ");
            sb.append((String)me.getKey());
            if (me.getValue() instanceof String) {
                sb.append("\n          Value: ");
                sb.append((String)me.getValue());
                continue;
            }
            sb.append("\n          Value(Type): ");
            sb.append(me.getValue() == null ? "null" : me.getValue().getClass().getName());
        }
        sb.append("\n        DeltaProperties Count: ");
        sb.append(this.mDeltaProperties.size());
        sb.append("\n");
        for (Map.Entry me : this.mDeltaProperties.entrySet()) {
            sb.append("          Name: ");
            sb.append((String)me.getKey());
            if (me.getValue() instanceof String) {
                sb.append("\n          Value: ");
                sb.append((String)me.getValue());
                continue;
            }
            sb.append("\n          Value(Type): ");
            sb.append(me.getValue() == null ? "null" : me.getValue().getClass().getName());
        }
        sb.append("\n        Messages Count:   ");
        sb.append(this.mMessages.size());
        sb.append("\n");
        for (Map.Entry me : this.mMessages.entrySet()) {
            sb.append("          Message Name: ");
            sb.append((String)me.getKey());
            sb.append("\n");
            sb.append(me.getKey() == null ? "null" : me.getValue().toString());
        }
        if (this.mFault != null) {
            sb.append("        Fault: ");
            sb.append(this.mFault.toString());
        }
        return sb.toString();
    }
}

