/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.internal.support.DOMUtil;
import com.sun.jbi.management.internal.support.DirectoryUtil;
import com.sun.jbi.management.internal.support.JarFactory;
import com.sun.jbi.management.internal.support.XmlReader;
import com.sun.jbi.management.system.BuildManagementMessageImpl;
import com.sun.jbi.management.system.DeploymentUnitInfo;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementMessageHolder;
import com.sun.jbi.management.system.ServiceAssembly;
import com.sun.jbi.messaging.Link;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeploymentContextImpl {
    private URL mSAURL = null;
    private String mSAAbsolutePath = null;
    private Document mDoc = null;
    private StringBuffer mJbiXMLString = new StringBuffer("");
    private ArrayList mSURepository;
    private ArrayList mDeployInfo;
    private ManagementContext mContext = null;
    private String mSAUnzipLocation = null;
    private BuildManagementMessageImpl mMImpl = null;
    private ServiceAssembly mSA = null;
    private String mDeployRoot = null;
    private Logger mLogger = null;
    private StringTranslator mTranslator;
    private String mServiceAssemblyName = null;
    private boolean mIsDuplicateSA = false;

    public DeploymentContextImpl(URL saZipURL, ManagementContext aContext, Logger aLogger) {
        this.mSAURL = saZipURL;
        this.mContext = aContext;
        this.mLogger = aLogger;
        this.mMImpl = new BuildManagementMessageImpl();
        DeploymentContextImpl deploymentContextImpl = this;
        this.mTranslator = deploymentContextImpl.mContext.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        DeploymentContextImpl deploymentContextImpl2 = this;
        this.mDeployRoot = deploymentContextImpl2.mContext.getJbiInstallRoot() + File.separator + "system" + File.separator + "deployment";
    }

    public ArrayList buildDeploymentContext(String jbiXmlPath, boolean isDeployment) throws DeploymentException {
        Object retSUInfo = null;
        try {
            boolean isValidJbiXml = false;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (isDeployment) {
                this.mSA = new ServiceAssembly(this.mSAURL, this.mTranslator, this.mLogger);
                this.mDoc = db.parse(this.mSA.getJbiXml());
                boolean isDuplicate = this.isDuplicateSAName();
                this.mServiceAssemblyName = this.getSAName();
                if (isDuplicate) {
                    this.mIsDuplicateSA = true;
                    String errMsg = this.mTranslator.getString("DS_DUPLICATE_SERVICE_ASSEMBLY_NAME", "deploy", this.mServiceAssemblyName);
                    throw new Exception(errMsg);
                }
                this.unzipSA();
                isValidJbiXml = new XmlReader().validate(this.mSA.getJbiXml());
            } else {
                if (jbiXmlPath == null) {
                    String errMsg = this.mTranslator.getString("DS_UNABLE_TO_FIND_JBI_XML", "undeploy", this.mServiceAssemblyName);
                    throw new Exception(errMsg);
                }
                this.mDoc = db.parse(new File(jbiXmlPath));
                this.mServiceAssemblyName = this.getSAName();
                isValidJbiXml = new XmlReader().validate(jbiXmlPath);
            }
            if (!isValidJbiXml) {
                String taskName = null;
                this.mServiceAssemblyName = this.getSAName();
                taskName = isDeployment ? "deploy" : "undeploy";
                String errMsg = this.mTranslator.getString("DS_JBI_XML_VALIDATION_FAILED", taskName, this.mServiceAssemblyName);
                throw new Exception(errMsg);
            }
        }
        catch (SAXException se) {
            String jbiTaskRslt = null;
            String errMsg = this.mTranslator.getString("DS_CANNOT_PARSE_JBI_XML");
            jbiTaskRslt = isDeployment ? this.buildFrmwkExMsg("deploy", se, errMsg) : this.buildFrmwkExMsg("undeploy", se, errMsg);
            throw new DeploymentException(jbiTaskRslt);
        }
        catch (IOException ioe) {
            String jbiTaskRslt = null;
            String errMsg = this.mTranslator.getString("DS_JBI_XML_PARSE_IO_EXCEP");
            jbiTaskRslt = isDeployment ? this.buildFrmwkExMsg("deploy", ioe, errMsg) : this.buildFrmwkExMsg("undeploy", ioe, errMsg);
            throw new DeploymentException(jbiTaskRslt);
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            String jbiTaskRslt = null;
            String errMsg = null;
            errMsg = e.getMessage();
            if (!errMsg.startsWith("JBIMA")) {
                errMsg = this.mTranslator.getString("DS_GENERIC_JBI_XML_PARSE_EXCEP");
            }
            jbiTaskRslt = isDeployment ? this.buildFrmwkExMsg("deploy", e, errMsg) : this.buildFrmwkExMsg("undeploy", e, errMsg);
            throw new DeploymentException(jbiTaskRslt);
        }
        if (isDeployment) {
            return this.buildSURepository();
        }
        return this.getSUInfo();
    }

    public ServiceAssembly getServiceAssembly() {
        return this.mSA;
    }

    public String getSAName() throws DeploymentException {
        if (this.mServiceAssemblyName != null) {
            return this.mServiceAssemblyName;
        }
        try {
            Element saElem = DOMUtil.UTIL.getElement(this.mDoc, "service-assembly");
            if (saElem == null) {
                String errMsg = this.mTranslator.getString("DS_CANNOT_DEPLOY_SA_INVALID_JBI_XML", this.mSAAbsolutePath);
                String jbiExStr = this.buildFrmwkExMsg("getSAName", null, errMsg);
                throw new DeploymentException(jbiExStr);
            }
            Element saIdentificationElem = DOMUtil.UTIL.getElement(saElem, "identification");
            Element saNameElem = DOMUtil.UTIL.getElement(saIdentificationElem, "name");
            this.mServiceAssemblyName = DOMUtil.UTIL.getTextData(saNameElem);
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mServiceAssemblyName;
    }

    public List getSUList() {
        return null;
    }

    public String getTargetComponentName(String aSUId) {
        return null;
    }

    public Reader getArtifactsJar(String aSUName) {
        return null;
    }

    public String getDeploymentDescriptor() {
        return this.mJbiXMLString.toString();
    }

    private ArrayList buildSURepository() throws DeploymentException {
        ZipEntry ze = null;
        this.mSURepository = new ArrayList();
        try {
            ArrayList suInfoList = this.getSUInfo();
            Enumeration<? extends ZipEntry> e = this.mSA.getZipFile().entries();
            while (e.hasMoreElements()) {
                ze = e.nextElement();
                for (int i = 0; i < suInfoList.size(); ++i) {
                    DeploymentUnitInfo suInfo = (DeploymentUnitInfo)suInfoList.get(i);
                    if (!suInfo.getServiceUnitJarName().equals(ze.getName())) continue;
                    this.mSURepository.add(suInfo);
                }
            }
        }
        catch (Exception ioe) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_BUILD_SU_REPOS");
            String jbiTaskStr = this.buildFrmwkExMsg("buildSURepository", ioe, errMsg);
            throw new DeploymentException(jbiTaskStr);
        }
        return this.mSURepository;
    }

    private ArrayList getSUInfo() throws DeploymentException {
        if (this.mDeployInfo == null) {
            this.mDeployInfo = new ArrayList();
            NodeList nl = null;
            Element saElem = DOMUtil.UTIL.getElement(this.mDoc, "service-assembly");
            nl = DOMUtil.UTIL.getChildElements(saElem, "service-unit");
            if (nl.getLength() == 0) {
                String errMsg = this.mTranslator.getString("DS_CANNOT_FIND_SU_FRAGMENT_IN_JBI_XML");
                String jbiTaskStr = this.buildFrmwkExMsg("getSUInfo", null, errMsg);
                throw new DeploymentException(jbiTaskStr);
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                Node suNode = nl.item(i);
                if (!(suNode instanceof Element)) continue;
                Element elem = DOMUtil.UTIL.getElement((Element)suNode, "identification");
                Element suNameElem = DOMUtil.UTIL.getElement(elem, "name");
                String suName = DOMUtil.UTIL.getTextData(suNameElem);
                Element targetElem = DOMUtil.UTIL.getElement((Element)suNode, "target");
                Element ajElem = DOMUtil.UTIL.getElement(targetElem, "artifacts-zip");
                Element cmpNameElem = DOMUtil.UTIL.getElement(targetElem, "component-name");
                String artifactJarName = DOMUtil.UTIL.getTextData(ajElem);
                String compName = DOMUtil.UTIL.getTextData(cmpNameElem);
                this.mDeployInfo.add(new DeploymentUnitInfo(suName, compName, artifactJarName, this.getSAUnzipLocation()));
            }
        }
        return this.mDeployInfo;
    }

    public List getDeploymentInfo() throws DeploymentException {
        if (this.mDeployInfo == null) {
            this.mDeployInfo = this.getSUInfo();
        }
        return this.mDeployInfo;
    }

    private void unzipSA() throws DeploymentException {
        String saName = null;
        try {
            saName = this.getSAName();
            this.mSAUnzipLocation = this.mDeployRoot + File.separator + saName;
            JarFactory jfctry = new JarFactory(this.mSAUnzipLocation);
            jfctry.unJar(this.mSA.getZipFile());
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_UNZIP_SA", saName);
            String jbiTaskStr = this.buildFrmwkExMsg("unzipSA", e, errMsg);
            throw new DeploymentException(jbiTaskStr);
        }
    }

    public String getSAUnzipLocation() {
        if (this.mSAUnzipLocation == null) {
            this.mSAUnzipLocation = this.mDeployRoot + File.separator + this.mServiceAssemblyName;
        }
        return this.mSAUnzipLocation;
    }

    public void setDocument(Document aDoc) {
        this.mDoc = aDoc;
    }

    private boolean isDuplicateSAName() throws Exception {
        boolean isDuplicate = false;
        try {
            String saName = this.getSAName();
            String[] dirList = DirectoryUtil.getFolderNameListing(new File(this.mDeployRoot));
            if (dirList != null) {
                for (int i = 0; i < dirList.length; ++i) {
                    if (dirList[i] == null || !dirList[i].equalsIgnoreCase(saName)) continue;
                    isDuplicate = true;
                }
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return isDuplicate;
    }

    private String buildFrmwkExMsg(String methodName, Throwable ex, String errMsg) {
        String jbiTaskStr = null;
        try {
            ManagementMessageHolder mmHolder = new ManagementMessageHolder("EXCEPTION_MSG");
            mmHolder.setTaskName(methodName);
            mmHolder.setTaskResult("FAILED");
            String token = errMsg.substring(0, 9);
            mmHolder.setLocToken(1, token);
            String msg = errMsg.substring(11);
            mmHolder.setLocMessage(1, msg);
            if (ex != null) {
                mmHolder.setExceptionObject(ex);
            }
            mmHolder.setFrameworkLocale("en_US");
            jbiTaskStr = this.mMImpl.buildCompleteExceptionMessage(mmHolder);
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG", methodName);
            this.mLogger.severe(statusMsg);
        }
        return jbiTaskStr;
    }

    public Element getConnectionsElement() {
        Element saElem = DOMUtil.UTIL.getElement(this.mDoc, "service-assembly");
        return DOMUtil.UTIL.getElement(saElem, "connections");
    }

    public Link getLinkType(String fromEndpoint) throws Exception {
        Link linkType = null;
        String saName = null;
        try {
            List suInfoList = this.getDeploymentInfo();
            saName = this.getSAName();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            for (int i = 0; i < suInfoList.size(); ++i) {
                DeploymentUnitInfo suInfo = (DeploymentUnitInfo)suInfoList.get(i);
                String suRootPath = suInfo.getServiceUnitRoot();
                String suDescriptor = this.mDeployRoot + File.separator + saName + File.separator + suRootPath + File.separator + "META-INF" + File.separator + "jbi.xml";
                File jbiXmlFile = new File(suDescriptor);
                if (!jbiXmlFile.exists()) continue;
                Document doc = db.parse(jbiXmlFile);
                Element servicesElem = DOMUtil.UTIL.getElement(doc, "services");
                Element consumesElem = DOMUtil.UTIL.getElement(servicesElem, "consumes");
                if (consumesElem == null) {
                    return null;
                }
                String endpointName = DOMUtil.UTIL.getAttribute(consumesElem, "endpoint-name");
                if (!endpointName.equalsIgnoreCase(fromEndpoint)) continue;
                String linkTypeStr = DOMUtil.UTIL.getAttribute(consumesElem, "link-type");
                if (linkTypeStr.equalsIgnoreCase("HARD")) {
                    linkType = Link.HARD;
                }
                if (linkTypeStr.equalsIgnoreCase("STANDARD")) {
                    linkType = Link.STANDARD;
                }
                if (linkTypeStr.equalsIgnoreCase("SOFT")) {
                    linkType = Link.SOFT;
                }
                break;
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_UNABLE_TO_GET_LINK_TYPE_FROM_SU_DESCRIPTOR", saName);
            String jbiTaskStr = this.buildFrmwkExMsg("getLinkType", e, errMsg);
            throw new DeploymentException(jbiTaskStr);
        }
        return linkType;
    }

    public boolean isDuplicateSA() {
        return this.mIsDuplicateSA;
    }
}

