/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.internal.support;

import java.io.File;
import java.util.logging.Level;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntScriptRunner {
    public static boolean runAntTarget(String basedir, String antfn, String targetname) {
        Project project = new Project();
        boolean taskstatus = true;
        project.setBaseDir(new File(basedir));
        project.init();
        File buildFile = new File(antfn);
        ProjectHelper.configureProject((Project)project, (File)buildFile);
        if (targetname == null || targetname.equals("")) {
            targetname = project.getDefaultTarget();
        }
        DefaultLogger mylogger = new DefaultLogger();
        Level logLevel = Level.parse(System.getProperty("com.sun.jbi.defaultLogLevel", "INFO"));
        if (logLevel.intValue() >= Level.INFO.intValue()) {
            mylogger.setMessageOutputLevel(1);
        } else if (logLevel.intValue() >= Level.FINE.intValue()) {
            mylogger.setMessageOutputLevel(2);
        } else {
            mylogger.setMessageOutputLevel(3);
        }
        mylogger.setOutputPrintStream(System.out);
        mylogger.setErrorPrintStream(System.err);
        mylogger.setEmacsMode(true);
        project.addBuildListener((BuildListener)mylogger);
        project.setUserProperty("fooprop", "foovalue");
        try {
            project.executeTarget(targetname);
        }
        catch (Exception e) {
            System.out.println("AntScriptRunner:  ERROR: " + e.getMessage());
            taskstatus = false;
        }
        return taskstatus;
    }
}

