/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public abstract class ConfigurationFactory {
    private Logger mLog;
    private StringTranslator mTranslator;
    protected ConfigurationCategory mCategory;
    protected Properties mDefaults;

    public ConfigurationFactory(Properties defaults, ConfigurationCategory category) {
        this.mDefaults = defaults;
        this.mCategory = category;
    }

    public abstract ModelMBeanAttributeInfo[] createMBeanAttributeInfo();

    protected String getString(String key) {
        String str = this.getTranslator().getString(key);
        return MessageBuilder.getMessageString(str);
    }

    protected String getToken(String key) {
        String str = this.getTranslator().getString(key);
        return MessageBuilder.getMessageToken(str);
    }

    protected StringTranslator getTranslator() {
        if (this.mTranslator == null) {
            EnvironmentContext envCtx = EnvironmentAccess.getContext();
            this.mTranslator = envCtx.getStringTranslator("com.sun.jbi.management");
        }
        return this.mTranslator;
    }

    protected Logger getLogger() {
        if (this.mLog == null) {
            this.mLog = Logger.getLogger("com.sun.jbi.management");
        }
        return this.mLog;
    }

    protected String getQualifiedKey(String key) {
        StringBuffer strBuf = new StringBuffer(this.mCategory.toString().toLowerCase());
        strBuf.append(".");
        strBuf.append(key);
        return strBuf.toString();
    }

    protected String getDefaultLogLevel() {
        Level level = Logger.getLogger("com.sun.jbi").getLevel();
        if (level != null) {
            return level.toString();
        }
        return "INFO";
    }
}

