/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi;

import com.sun.jbi.ServiceUnitState;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServiceAssemblyState {
    SHUTDOWN("Shutdown"),
    STOPPED("Stopped"),
    STARTED("Started"),
    UNKNOWN("Unknown");

    private String mString;

    private ServiceAssemblyState(String strValue) {
        this.mString = strValue;
    }

    public static ServiceAssemblyState computeServiceAssemblyState(List<ServiceUnitState> suStates) {
        if (suStates.contains((Object)ServiceUnitState.STARTED)) {
            return STARTED;
        }
        if (suStates.contains((Object)ServiceUnitState.STOPPED)) {
            return STOPPED;
        }
        return SHUTDOWN;
    }

    public static ServiceAssemblyState getEffectiveServiceAssemblyState(List<ServiceAssemblyState> saStates) {
        if (saStates.contains((Object)STARTED)) {
            return STARTED;
        }
        if (saStates.contains((Object)STOPPED)) {
            return STOPPED;
        }
        if (saStates.contains((Object)SHUTDOWN)) {
            return SHUTDOWN;
        }
        return UNKNOWN;
    }

    public static String convertState(ServiceAssemblyState state) {
        String dsState = state == STARTED ? "Started" : (state == STOPPED ? "Stopped" : "Shutdown");
        return dsState;
    }

    public static ServiceAssemblyState valueOfDeploymentServiceState(String state) {
        ServiceAssemblyState saState = "Started".equals(state) ? STARTED : ("Stopped".equals(state) ? STOPPED : SHUTDOWN);
        return saState;
    }

    public String toString() {
        return this.mString;
    }

    public static ServiceAssemblyState valueOfString(String valStr) {
        return ServiceAssemblyState.valueOf(valStr.toUpperCase());
    }

    public static void main(String[] args) {
        System.out.println(STOPPED.toString());
        System.out.println(ServiceAssemblyState.valueOfString("Stopped").toString());
        System.out.println(ServiceAssemblyState.valueOfString("StoPPed").toString());
        System.out.println(ServiceAssemblyState.valueOfString("sTaRted").toString());
    }
}

