/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.InputsAndOutputs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class CliUtil {
    public native String[] getEnv(String var1);

    public native String[] getAllEnv();

    public native String getPassword();

    public native char getKeyboardInput();

    public CliUtil() {
        CliUtil.loadCliNative();
    }

    private static synchronized void loadCliNative() {
        if (System.getProperty("sun.arch.data.model").equals("64") && System.getProperty("os.name").equals("Linux")) {
            try {
                System.loadLibrary("cliutil64");
            }
            catch (UnsatisfiedLinkError e) {
                System.loadLibrary("cliutil");
            }
        } else {
            System.loadLibrary("cliutil");
        }
    }

    public String getPassword(String prompt) {
        InputsAndOutputs.getInstance().getUserOutput().print(prompt);
        return this.getPassword();
    }

    public static void main(String[] args) {
        String sEnvPrefix = "PS_ADMIN_";
        boolean bContinue = true;
        while (bContinue) {
            System.out.println("Menu");
            System.out.println("[1] get environment");
            System.out.println("[2] get password");
            System.out.println("[3] get keyboard press");
            System.out.println("[4] get all environment");
            System.out.println("[5] exit");
            String line = CliUtil.getText();
            if (line.equals("1")) {
                String[] sEnvVal = new CliUtil().getEnv("PS_ADMIN_");
                for (int ii = 0; ii < sEnvVal.length; ++ii) {
                    String sName = sEnvVal[ii];
                    if (!sName.regionMatches(true, 0, "PS_ADMIN_", 0, "PS_ADMIN_".length())) continue;
                    System.out.println(sName);
                }
                continue;
            }
            if (line.equals("2")) {
                String sPassword = new CliUtil().getPassword("Enter password>");
                System.out.println("Password entered = " + sPassword);
                continue;
            }
            if (line.equals("3")) {
                char c = new CliUtil().getKeyboardInput();
                System.out.println("\n key entered = " + c);
                continue;
            }
            if (line.equals("4")) {
                String[] envs = new CliUtil().getAllEnv();
                System.out.println("Get All Environment");
                for (String env : envs) {
                    System.out.println(env);
                }
                continue;
            }
            if (line.equals("5")) {
                bContinue = false;
                continue;
            }
            System.out.println("You did not entered the right option.");
        }
    }

    private static String getText() {
        String s = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            s = in.readLine();
        }
        catch (IOException exc) {
            System.err.println("Caught exception: " + exc);
        }
        return s;
    }
}

