/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ApplicationMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.WebModuleVirtualServerMonitor;
import com.sun.appserv.management.monitor.statistics.WebModuleVirtualServerStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;

public class WebModuleVirtualServerMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-8s %9$-10s %10$-5s";
    private String appFilter = null;
    private String webFilter = null;

    public WebModuleVirtualServerMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        if (this.filter == null) {
            this.getDefaultFilter();
        } else {
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            if (st.countTokens() < 2) {
                this.webFilter = st.nextToken();
            } else {
                this.appFilter = st.nextToken();
                this.webFilter = st.nextToken();
            }
            this.verifyFilterValue();
        }
        String webmoduleVSMonitoringTitle = localStrings.getString("commands.monitor.webmodule_virtual_server_monitoring_title", new Object[]{this.filter});
        String title = String.format("%1$50s", webmoduleVSMonitoringTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        WebModuleVirtualServerMonitor vsMonitor;
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Object vsStat = null;
        Map webMap = null;
        if (this.appFilter == null) {
            webMap = this.srm.getWebModuleVirtualServerMonitorMap();
        } else {
            Map appMap = this.srm.getApplicationMonitorMap();
            if (appMap == null || appMap.size() < 1) {
                this.cancelMonitorTask();
                return;
            }
            ApplicationMonitor am = (ApplicationMonitor)appMap.get(this.appFilter);
            if (am == null) {
                this.cancelMonitorTask();
                return;
            }
            webMap = am.getWebModuleVirtualServerMonitorMap();
        }
        if (webMap == null || webMap.size() < 1) {
            this.cancelMonitorTask();
        }
        if ((vsMonitor = (WebModuleVirtualServerMonitor)webMap.get(this.webFilter)) == null) {
            this.cancelMonitorTask();
            return;
        }
        WebModuleVirtualServerStats vsStats = vsMonitor.getWebModuleVirtualServerStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(vsStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private String[] possibleAppModuleFilters() {
        Map appModuleMap = this.srm.getApplicationMonitorMap();
        Vector<String> possibleFilters = new Vector<String>();
        if (appModuleMap != null && appModuleMap.size() > 0) {
            String[] appModules;
            for (String appModule : appModules = MapUtil.getKeyStrings((Map)appModuleMap)) {
                String[] webModules;
                ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(appModule);
                Map innerWebModuleMap = am.getWebModuleVirtualServerMonitorMap();
                if (innerWebModuleMap == null || innerWebModuleMap.size() <= 0) continue;
                for (String webModule : webModules = MapUtil.getKeyStrings((Map)innerWebModuleMap)) {
                    possibleFilters.add(appModule + ":" + webModule);
                }
            }
        }
        return possibleFilters.toArray(new String[0]);
    }

    private String[] possibleWebModuleFilters() {
        Map webModuleMap = this.srm.getWebModuleVirtualServerMonitorMap();
        Vector<String> possibleFilters = new Vector<String>();
        String[] webModules = MapUtil.getKeyStrings((Map)webModuleMap);
        if (webModuleMap != null && webModuleMap.size() > 0) {
            for (String webModule : webModules) {
                possibleFilters.add(webModule);
            }
        }
        return possibleFilters.toArray(new String[0]);
    }

    private void getDefaultFilter() throws MonitorTaskException {
        String[] appModuleFilters = this.possibleAppModuleFilters();
        String[] webModuleFilters = this.possibleWebModuleFilters();
        if (webModuleFilters.length < 1 && appModuleFilters.length < 1) {
            throw new MonitorTaskException(localStrings.getString("command.monitor.no_value_to_monitor"));
        }
        if (webModuleFilters.length == 1 && appModuleFilters.length < 1) {
            this.filter = this.webFilter = webModuleFilters[0];
        } else if (webModuleFilters.length < 1 && appModuleFilters.length == 1) {
            this.filter = appModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.appFilter = st.nextToken();
            this.webFilter = st.nextToken();
        } else {
            String msg = this.getAvailableFilterMessage(appModuleFilters, webModuleFilters);
            throw new MonitorTaskException(msg);
        }
    }

    private String getAvailableFilterMessage(String[] appModuleFilters, String[] webModuleFilters) {
        StringBuffer sb = new StringBuffer();
        sb.append(localStrings.getString("commands.monitor.more_than_one_monitoring_elements"));
        if (webModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_webmodule_elements"));
            for (String webmodule : webModuleFilters) {
                sb.append("    ");
                sb.append(webmodule);
                sb.append("\n");
            }
        }
        if (appModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_webmodule_elements_in_appmodule"));
            for (String appmodule : appModuleFilters) {
                sb.append("    ");
                sb.append(appmodule);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyFilterValue() throws MonitorTaskException {
        if (this.appFilter != null) {
            Map appModuleMap = this.srm.getApplicationMonitorMap();
            if (!appModuleMap.containsKey(this.appFilter)) throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.appFilter}));
            ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(this.appFilter);
            Map innerWebModuleMap = am.getWebModuleVirtualServerMonitorMap();
            if (innerWebModuleMap.containsKey(this.webFilter)) return;
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.webFilter, this.appFilter}));
        }
        Map webModuleMap = this.srm.getWebModuleVirtualServerMonitorMap();
        if (webModuleMap.containsKey(this.webFilter)) return;
        throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.webFilter}));
    }

    private void displayHeader() {
        String asc = localStrings.getString("commands.monitor.asc");
        String ash = localStrings.getString("commands.monitor.ash");
        String est = localStrings.getString("commands.monitor.est");
        String jc = localStrings.getString("commands.monitor.jc");
        String jec = localStrings.getString("commands.monitor.jec");
        String jrc = localStrings.getString("commands.monitor.jrc");
        String rst = localStrings.getString("commands.monitor.rst");
        String svpt = localStrings.getString("commands.monitor.svpt");
        String ss = localStrings.getString("commands.monitor.ss");
        String sst = localStrings.getString("commands.monitor.sst");
        String header = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-8s %9$-10s %10$-5s", asc, ash, est, jc, jec, jrc, rst, svpt, ss, sst);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.webmodule_virtual_server_write_to_file"));
        }
    }

    private void displayData(WebModuleVirtualServerStats stat) {
        String data = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-8s %9$-10s %10$-5s", stat.getActiveSessionsCurrent().getCount(), stat.getActiveSessionsHigh().getCount(), stat.getExpiredSessionsTotal().getCount(), stat.getJSPCount().getCount(), stat.getJSPErrorCount().getCount(), stat.getJSPReloadCount().getCount(), stat.getRejectedSessionsTotal().getCount(), stat.getServletProcessingTimes().getCount(), stat.getSessions().getCurrent(), stat.getSessionsTotal().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,%10$s", stat.getActiveSessionsCurrent().getCount(), stat.getActiveSessionsHigh().getCount(), stat.getExpiredSessionsTotal().getCount(), stat.getJSPCount().getCount(), stat.getJSPErrorCount().getCount(), stat.getJSPReloadCount().getCount(), stat.getRejectedSessionsTotal().getCount(), stat.getServletProcessingTimes().getCount(), stat.getSessions().getCurrent(), stat.getSessionsTotal().getCount());
            this.writeToFile(fileData);
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.webmodule_virtual_server_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

