/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ConnectionQueueMonitor;
import com.sun.appserv.management.monitor.HTTPServiceMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.ConnectionQueueStats;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Timer;

public class ConnectionQueueMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-5s %10$-5s";

    public ConnectionQueueMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        String connQueueMonitoring = localStrings.getString("commands.monitor.connection_queue_monitoring_title");
        String title = String.format("%1$42s", connQueueMonitoring);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        HTTPServiceMonitor httpserviceMonitor = this.srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        ConnectionQueueMonitor connectionQueueMonitor = httpserviceMonitor.getConnectionQueueMonitor();
        if (connectionQueueMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        ConnectionQueueStats connectionQueueStats = connectionQueueMonitor.getConnectionQueueStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(connectionQueueStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void displayHeader() {
        String of = localStrings.getString("commands.monitor.of");
        String que = localStrings.getString("commands.monitor.que");
        String fifteen_a = localStrings.getString("commands.monitor.15a");
        String one_a = localStrings.getString("commands.monitor.1a");
        String five_a = localStrings.getString("commands.monitor.5a");
        String tcon = localStrings.getString("commands.monitor.tcon");
        String tque = localStrings.getString("commands.monitor.tque");
        String id = localStrings.getString("commands.monitor.id");
        String mque = localStrings.getString("commands.monitor.mque");
        String pque = localStrings.getString("commands.monitor.pque");
        String header = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-5s %10$-5s", of, que, fifteen_a, one_a, five_a, tcon, tque, id, mque, pque);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.connection_queue_write_to_file"));
        }
    }

    private void displayData(ConnectionQueueStats cqs) {
        String data = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-5s %10$-5s", cqs.getCountOverflows().getCount(), cqs.getCountQueued().getCount(), cqs.getCountQueued15MinuteAverage().getCount(), cqs.getCountQueued1MinuteAverage().getCount(), cqs.getCountQueued5MinuteAverage().getCount(), cqs.getCountTotalConnections().getCount(), cqs.getCountTotalQueued().getCount(), cqs.getID().getCurrent(), cqs.getMaxQueued().getCount(), cqs.getPeakQueued().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,%10$s", cqs.getCountOverflows().getCount(), cqs.getCountQueued().getCount(), cqs.getCountQueued15MinuteAverage().getCount(), cqs.getCountQueued1MinuteAverage().getCount(), cqs.getCountQueued5MinuteAverage().getCount(), cqs.getCountTotalConnections().getCount(), cqs.getCountTotalQueued().getCount(), cqs.getID().getCurrent(), cqs.getMaxQueued().getCount(), cqs.getPeakQueued().getCount());
            this.writeToFile(fileData);
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.connection_queue_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

