/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.MultiProcessCommand;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.HashMap;
import java.util.Vector;

public class ExportCommand
extends S1ASCommand {
    private static final String ENVIRONMENT_PREFIX = "AS_ADMIN_";
    private static final String ENVIRONMENT_DELIMITER = "=";
    private static final String PASSWORD_STRING = "password";
    private CommandEnvironment commandEnvironment = CommandEnvironment.getInstance();

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        Vector operands = this.getOperands();
        if (operands.size() == 0) {
            this.printAllEnvValues();
            return;
        }
        for (int ii = 0; ii < operands.size(); ++ii) {
            this.updateEnvironment((String)operands.elementAt(ii));
        }
    }

    private String checkForPrefix(String name) throws CommandException {
        String envName = null;
        if (!name.regionMatches(true, 0, ENVIRONMENT_PREFIX, 0, ENVIRONMENT_PREFIX.length())) {
            throw new CommandException(this.getLocalizedString("CouldNotSetVariable", new Object[]{name}));
        }
        envName = name.substring(ENVIRONMENT_PREFIX.length());
        return envName.toLowerCase();
    }

    private void printAllEnvValues() {
        if (this.commandEnvironment.getNumEnvironments() == 0 && MultiProcessCommand.getNumLocalEnvironments() == 0) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoEnvironment"));
        } else {
            HashMap allEnvironments = this.commandEnvironment.getEnvironments();
            allEnvironments.putAll(MultiProcessCommand.getLocalEnvironments());
            this.printEnvValues(allEnvironments);
        }
    }

    private void printEnvValues(HashMap allEnvironments) {
        for (String name : allEnvironments.keySet()) {
            CLILogger.getInstance().printDebugMessage(this.commandEnvironment.toString());
            Object value = allEnvironments.get(name);
            this.printEnvValue(name, value);
        }
    }

    private void printEnvValue(String name, Object value) {
        String displayName = ENVIRONMENT_PREFIX.concat(name.toUpperCase());
        if (name.endsWith(PASSWORD_STRING)) {
            CLILogger.getInstance().printMessage(displayName + " = ********");
        } else {
            CLILogger.getInstance().printMessage(displayName + " = " + value);
        }
    }

    private void updateEnvironment(String nameStr) throws CommandException {
        int nameend = nameStr.indexOf(ENVIRONMENT_DELIMITER);
        if (nameend == nameStr.length() - 1) {
            String envName = this.checkForPrefix(nameStr.substring(0, nameend));
            if (MultiProcessCommand.removeLocalEnvironment(envName) != null) {
                this.commandEnvironment.removeEnvironment(envName);
            } else if (this.commandEnvironment.removeEnvironment(envName) == null) {
                throw new CommandException(this.getLocalizedString("UnableToRemoveEnv", new Object[]{nameStr.subSequence(0, nameend)}));
            }
        } else if (nameend == -1) {
            String name = this.checkForPrefix(nameStr);
            if (MultiProcessCommand.getLocalEnvironmentValue(name) != null) {
                this.printEnvValue(name, MultiProcessCommand.getLocalEnvironmentValue(name));
            } else {
                this.printEnvValue(name, this.commandEnvironment.getEnvironmentValue(name));
            }
        } else {
            String envName = this.checkForPrefix(nameStr.substring(0, nameend));
            if (envName.matches(this.NOT_DEPRECATED_PASSWORDFILE_OPTIONS)) {
                MultiProcessCommand.setLocalEnvironment(envName, nameStr.substring(nameend + 1));
            } else {
                this.commandEnvironment.setEnvironment(envName, nameStr.substring(nameend + 1));
            }
        }
    }
}

