/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.monitor.CallFlowMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Map;
import javax.management.MBeanServerConnection;

public class CallflowCommand
extends S1ASCommand {
    private static final String FILTER_TYPE_OPTION = "filtertype";
    private static final String CALLER_IPFILTER = "CallerIPFilter";
    private static final String CALLER_PRINCIPALFILTER = "CallerPrincipalFilter";
    private static final String ENABLED = "Enabled";
    private static final String FILTER_TYPE_USER = "user";
    private static final String FILTER_TYPE_IP = "ip";
    private static final String START_CALL_FLOW = "start-callflow-monitoring";
    private String sFilterIP = null;
    private String sFilterUserID = null;

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String instanceName = (String)this.getOperands().get(0);
        try {
            this.verifyTargetInstance(mbsc, instanceName);
            CallFlowMonitor cfm = this.getCallFlowMonitor(mbsc, instanceName);
            this.setCallFlowConfig(cfm);
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
    }

    private void validateFilterType() throws CommandException, CommandValidationException {
        if (this.getOption(FILTER_TYPE_OPTION) != null) {
            String filterType = this.getOption(FILTER_TYPE_OPTION);
            CLITokenizer filterTypeTok = new CLITokenizer(filterType, ":");
            while (filterTypeTok.hasMoreTokens()) {
                String nameAndvalue = filterTypeTok.nextToken();
                CLITokenizer nameTok = new CLITokenizer(nameAndvalue, "=");
                if (nameTok.countTokens() == 2) {
                    String sName = nameTok.nextTokenWithoutEscapeAndQuoteChars();
                    String sValue = nameTok.nextTokenWithoutEscapeAndQuoteChars();
                    if (sName.equals(FILTER_TYPE_IP)) {
                        this.sFilterIP = sValue;
                        continue;
                    }
                    if (sName.equals(FILTER_TYPE_USER)) {
                        this.sFilterUserID = sValue;
                        continue;
                    }
                    throw new CommandValidationException(this.getLocalizedString("InvalidFilterName", new Object[]{sName}));
                }
                throw new CommandValidationException(this.getLocalizedString("InvalidFilterType", new Object[]{filterType}));
            }
        }
    }

    private void setCallFlowConfig(CallFlowMonitor cfm) throws CommandException, CommandValidationException {
        this.validateFilterType();
        Boolean bEnable = this.name.equals(START_CALL_FLOW);
        if (cfm != null) {
            cfm.setEnabled(bEnable.booleanValue());
            if (this.sFilterIP != null) {
                cfm.setCallerIPFilter(this.sFilterIP);
            }
            if (this.sFilterUserID != null) {
                cfm.setCallerPrincipalFilter(this.sFilterUserID);
            }
        }
    }

    private CallFlowMonitor getCallFlowMonitor(MBeanServerConnection mbsc, String instanceName) {
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        Map serverRootMonitorMap = domainRoot.getMonitoringRoot().getServerRootMonitorMap();
        ServerRootMonitor serverRootMonitor = (ServerRootMonitor)serverRootMonitorMap.get(instanceName);
        if (serverRootMonitor == null) {
            return null;
        }
        CallFlowMonitor cfm = serverRootMonitor.getCallFlowMonitor();
        return cfm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyTargetInstance(MBeanServerConnection mbsc, String instanceName) throws CommandException {
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        boolean isServer = false;
        isServer = domainRoot.getDomainConfig().getServerConfigMap().keySet().contains(instanceName);
        if (!isServer) {
            throw new CommandException(this.getLocalizedString("TargetNotAnInstance", new Object[]{instanceName}));
        }
        Map servers = domainRoot.getJ2EEDomain().getJ2EEServerMap();
        J2EEServer server = (J2EEServer)servers.get(instanceName);
        if (server != null) {
            if (server.getstate() == 1) return;
        }
        if (server.getstate() == 0) {
            return;
        }
        boolean bl = false;
        boolean running = bl;
        if (running) return;
        throw new CommandException(this.getLocalizedString("InstanceNotRunning", new Object[]{instanceName}));
    }
}

