/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.platform.ModuleClassID;

public abstract class ModuleClassAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private ModuleClassID id = null;
    private String name = null;
    private Element description = null;

    public static String getAdvertisementType() {
        return "jxta:MCA";
    }

    public final String getBaseAdvType() {
        return ModuleClassAdvertisement.getAdvertisementType();
    }

    public ModuleClassAdvertisement clone() {
        try {
            ModuleClassAdvertisement clone = (ModuleClassAdvertisement)super.clone();
            clone.setModuleClassID(this.getModuleClassID());
            clone.setName(this.getName());
            clone.setDesc(this.description);
            return clone;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public ID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Desc", description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }

    public ModuleClassID getModuleClassID() {
        return this.id;
    }

    public void setModuleClassID(ModuleClassID id) {
        this.id = id;
    }
}

