/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xindice.core;

import java.util.HashMap;
import java.util.Map;
import net.jxta.impl.xindice.core.DBException;

public abstract class FaultCodes {
    public static final int GEN = 0;
    public static final int OBJ = 100;
    public static final int COL = 200;
    public static final int IDX = 300;
    public static final int TRX = 400;
    public static final int DBE = 500;
    public static final int QRY = 600;
    public static final int SEC = 700;
    public static final int URI = 800;
    public static final int JAVA = 2000;
    public static final int GEN_UNKNOWN = 0;
    public static final int GEN_GENERAL_ERROR = 40;
    public static final int GEN_CRITICAL_ERROR = 70;
    public static final int GEN_FATAL_ERROR = 90;
    public static final int OBJ_OBJECT_NOT_FOUND = 100;
    public static final int OBJ_METHOD_NOT_FOUND = 101;
    public static final int OBJ_NULL_RESULT = 140;
    public static final int OBJ_INVALID_RESULT = 141;
    public static final int OBJ_DUPLICATE_OBJECT = 142;
    public static final int OBJ_RUNTIME_EXCEPTION = 170;
    public static final int OBJ_CLASS_FORMAT_ERROR = 171;
    public static final int OBJ_INVALID_CONTEXT = 172;
    public static final int OBJ_CANNOT_CREATE = 173;
    public static final int COL_COLLECTION_NOT_FOUND = 200;
    public static final int COL_DOCUMENT_NOT_FOUND = 201;
    public static final int COL_DUPLICATE_COLLECTION = 240;
    public static final int COL_NULL_RESULT = 241;
    public static final int COL_NO_FILER = 242;
    public static final int COL_NO_INDEXMANAGER = 242;
    public static final int COL_DOCUMENT_MALFORMED = 243;
    public static final int COL_CANNOT_STORE = 244;
    public static final int COL_CANNOT_RETRIEVE = 245;
    public static final int COL_COLLECTION_READ_ONLY = 246;
    public static final int COL_COLLECTION_CLOSED = 247;
    public static final int COL_CANNOT_CREATE = 270;
    public static final int COL_CANNOT_DROP = 271;
    public static final int IDX_VALUE_NOT_FOUND = 300;
    public static final int IDX_INDEX_NOT_FOUND = 301;
    public static final int IDX_MATCHES_NOT_FOUND = 340;
    public static final int IDX_DUPLICATE_INDEX = 341;
    public static final int IDX_NOT_SUPPORTED = 370;
    public static final int IDX_STYLE_NOT_FOUND = 371;
    public static final int IDX_CORRUPTED = 372;
    public static final int IDX_CANNOT_CREATE = 373;
    public static final int TRX_DOC_LOCKED = 400;
    public static final int TRX_NO_CONTEXT = 440;
    public static final int TRX_NOT_ACTIVE = 441;
    public static final int TRX_NOT_SUPPORTED = 470;
    public static final int DBE_NO_PARENT = 500;
    public static final int DBE_CANNOT_DROP = 570;
    public static final int DBE_CANNOT_CREATE = 571;
    public static final int QRY_NULL_RESULT = 600;
    public static final int QRY_COMPILATION_ERROR = 640;
    public static final int QRY_PROCESSING_ERROR = 641;
    public static final int QRY_NOT_SUPPORTED = 670;
    public static final int QRY_STYLE_NOT_FOUND = 671;
    public static final int SEC_INVALID_USER = 770;
    public static final int SEC_INVALID_GROUP = 771;
    public static final int SEC_INVALID_ACCESS = 772;
    public static final int SEC_INVALID_CREDENTIALS = 773;
    public static final int URI_EMPTY = 800;
    public static final int URI_NULL = 801;
    public static final int URI_PARSE_ERROR = 820;
    public static final int JAVA_RUNTIME_ERROR = 2070;
    private static final Map<Integer, String> FaultMsg = new HashMap<Integer, String>();

    private FaultCodes() {
    }

    private static void putCodeMessage(int code, String message) {
        FaultMsg.put(code, message);
    }

    public static String getMessage(int code) {
        String msg = FaultMsg.get(code);
        return msg != null ? msg : "";
    }

    public static int getFaultCodeType(Exception e) {
        int code = 0;
        if (e instanceof DBException) {
            code = ((DBException)e).faultCode;
        }
        code %= 100;
        code -= code % 10;
        return code;
    }

    public static int getFaultCodeSeries(Exception e) {
        int code = 0;
        if (e instanceof DBException) {
            code = ((DBException)e).faultCode;
        }
        code -= code % 100;
        return code;
    }

    public static int getFaultCode(Exception e) {
        if (e instanceof DBException) {
            return ((DBException)e).faultCode;
        }
        return 0;
    }

    public static String getFaultMessage(Exception e) {
        return FaultCodes.getMessage(FaultCodes.getFaultCode(e));
    }

    static {
        FaultCodes.putCodeMessage(0, "Unknown");
        FaultCodes.putCodeMessage(40, "General Error");
        FaultCodes.putCodeMessage(70, "Critical Error");
        FaultCodes.putCodeMessage(90, "Fatal Error");
        FaultCodes.putCodeMessage(100, "XMLObject Not Found");
        FaultCodes.putCodeMessage(101, "XMLObject Method Not Found");
        FaultCodes.putCodeMessage(140, "XMLObject Null Result");
        FaultCodes.putCodeMessage(141, "XMLObject Invalid Result");
        FaultCodes.putCodeMessage(142, "XMLObject Duplicate Object");
        FaultCodes.putCodeMessage(170, "XMLObject Runtime Exception");
        FaultCodes.putCodeMessage(171, "XMLObject Class Format Error");
        FaultCodes.putCodeMessage(172, "XMLObject Invalid Context");
        FaultCodes.putCodeMessage(173, "XMLObject Cannot Create");
        FaultCodes.putCodeMessage(200, "Collection Not Found");
        FaultCodes.putCodeMessage(201, "Collection Document Not Found");
        FaultCodes.putCodeMessage(240, "Collection Duplicated");
        FaultCodes.putCodeMessage(241, "Collection Null Result");
        FaultCodes.putCodeMessage(242, "Collection No Filer");
        FaultCodes.putCodeMessage(242, "Collection No IndexManager");
        FaultCodes.putCodeMessage(243, "Collection Document Malformed");
        FaultCodes.putCodeMessage(244, "Collection Cannot Store");
        FaultCodes.putCodeMessage(245, "Collection Cannot Retrieve");
        FaultCodes.putCodeMessage(246, "Collection Read-only");
        FaultCodes.putCodeMessage(247, "Collection Closed");
        FaultCodes.putCodeMessage(270, "Collection Cannot Create");
        FaultCodes.putCodeMessage(271, "Collection Cannot Drop");
        FaultCodes.putCodeMessage(300, "Index Value Not Found");
        FaultCodes.putCodeMessage(301, "Index Not Found");
        FaultCodes.putCodeMessage(340, "Index Matches Not Found");
        FaultCodes.putCodeMessage(341, "Index Duplicate Index");
        FaultCodes.putCodeMessage(370, "Index Not Supported");
        FaultCodes.putCodeMessage(371, "Index Style Not Found");
        FaultCodes.putCodeMessage(372, "Index Corrupted");
        FaultCodes.putCodeMessage(373, "Index Cannot Create");
        FaultCodes.putCodeMessage(400, "Transaction Document Locked");
        FaultCodes.putCodeMessage(440, "Transaction No Context");
        FaultCodes.putCodeMessage(441, "Transaction Not Active");
        FaultCodes.putCodeMessage(470, "Transaction Not Supported");
        FaultCodes.putCodeMessage(500, "Database No Parent");
        FaultCodes.putCodeMessage(570, "Database Cannot Drop");
        FaultCodes.putCodeMessage(571, "Database Cannot Create");
        FaultCodes.putCodeMessage(600, "Query Null Result");
        FaultCodes.putCodeMessage(640, "Query Compilation Error");
        FaultCodes.putCodeMessage(641, "Query Processing Error");
        FaultCodes.putCodeMessage(670, "Query Not Supported");
        FaultCodes.putCodeMessage(671, "Query Style Not Found");
        FaultCodes.putCodeMessage(770, "Security Invalid User");
        FaultCodes.putCodeMessage(771, "Security Invalid Group");
        FaultCodes.putCodeMessage(772, "Security Invalid Access");
        FaultCodes.putCodeMessage(773, "Security Invalid Credentials");
        FaultCodes.putCodeMessage(800, "URI Empty");
        FaultCodes.putCodeMessage(801, "URI Null");
        FaultCodes.putCodeMessage(820, "URI Parse Error");
        FaultCodes.putCodeMessage(2070, "Java Runtime Error");
    }
}

