/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.util.ACLSeedingManager;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.URISeedingManager;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public class RdvAdvSeedingManager
extends ACLSeedingManager {
    private static final transient Logger LOG = Logger.getLogger(URISeedingManager.class.getName());
    static final long MIN_REFRESH_INTERVAL = 30000L;
    final PeerGroup group;
    final String serviceName;
    long nextRemoteDiscovery = 0L;
    final List<RouteAdvertisement> discoveredRoutes = new ArrayList<RouteAdvertisement>();

    public RdvAdvSeedingManager(URI aclLocation, PeerGroup group, String serviceName) {
        super(aclLocation);
        this.group = group;
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshActiveSeeds() {
        DiscoveryService discovery = this.group.getDiscoveryService();
        if (null != discovery && TimeUtils.timeNow() > this.nextRemoteDiscovery) {
            Enumeration<Advertisement> advs;
            discovery.getRemoteAdvertisements(null, 2, "RdvServiceName", this.serviceName, 3);
            try {
                advs = discovery.getLocalAdvertisements(2, "RdvServiceName", this.serviceName);
            }
            catch (IOException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failure retrieving advertisements", failed);
                }
                return;
            }
            RdvAdvSeedingManager rdvAdvSeedingManager = this;
            synchronized (rdvAdvSeedingManager) {
                this.discoveredRoutes.clear();
                while (advs.hasMoreElements()) {
                    Advertisement anAdv = advs.nextElement();
                    if (!(anAdv instanceof RdvAdvertisement)) continue;
                    RdvAdvertisement rdvAdv = (RdvAdvertisement)anAdv;
                    RouteAdvertisement routeAdv = rdvAdv.getRouteAdv();
                    routeAdv.setDestPeerID(rdvAdv.getPeerID());
                    this.discoveredRoutes.add(routeAdv);
                }
                Collections.shuffle(this.discoveredRoutes);
                this.nextRemoteDiscovery = this.discoveredRoutes.isEmpty() ? TimeUtils.toAbsoluteTimeMillis(15000L) : TimeUtils.toAbsoluteTimeMillis(30000L);
            }
        }
    }

    public void stop() {
    }

    public synchronized URI[] getActiveSeedURIs() {
        boolean addedEA;
        this.refreshActiveSeeds();
        ArrayList<URI> results = new ArrayList<URI>();
        int eaIndex = 0;
        do {
            addedEA = false;
            for (RouteAdvertisement aRA : this.discoveredRoutes) {
                List<EndpointAddress> raEAs = aRA.getDestEndpointAddresses();
                if (eaIndex >= raEAs.size()) continue;
                URI seedURI = raEAs.get(eaIndex).toURI();
                if (!results.contains(seedURI)) {
                    results.add(seedURI);
                }
                addedEA = true;
            }
            ++eaIndex;
        } while (addedEA);
        return results.toArray(new URI[results.size()]);
    }

    public synchronized RouteAdvertisement[] getActiveSeedRoutes() {
        this.refreshActiveSeeds();
        ArrayList<RouteAdvertisement> results = new ArrayList<RouteAdvertisement>();
        for (RouteAdvertisement eachRoute : this.discoveredRoutes) {
            if (results.contains(eachRoute)) continue;
            results.add(eachRoute);
        }
        return results.toArray(new RouteAdvertisement[results.size()]);
    }
}

