/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.impl.resolver.resolverMeter.SrdiDestinationMeter;
import net.jxta.impl.resolver.resolverMeter.SrdiDestinationMetric;
import net.jxta.impl.resolver.resolverMeter.SrdiHandlerMetric;
import net.jxta.peer.PeerID;
import net.jxta.protocol.ResolverSrdiMsg;

public class SrdiHandlerMeter {
    private String handlerName;
    private SrdiHandlerMetric cumulativeMetrics;
    private SrdiHandlerMetric deltaMetrics;
    private Hashtable srdiDestinationMeters = new Hashtable();

    public SrdiHandlerMeter(String handlerName) {
        this.handlerName = handlerName;
        this.cumulativeMetrics = new SrdiHandlerMetric(handlerName);
    }

    public SrdiHandlerMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public synchronized SrdiHandlerMetric collectMetrics() {
        SrdiHandlerMetric prevDelta = this.deltaMetrics;
        Enumeration e = this.srdiDestinationMeters.elements();
        while (e.hasMoreElements()) {
            SrdiDestinationMeter srdiDestinationMeter = (SrdiDestinationMeter)e.nextElement();
            SrdiDestinationMetric srdiDestinationMetric = srdiDestinationMeter.collectMetrics();
            if (srdiDestinationMetric == null) continue;
            if (prevDelta == null) {
                this.createDeltaMetric();
                prevDelta = this.deltaMetrics;
            }
            prevDelta.addSrdiDestinationMetric(srdiDestinationMetric);
        }
        this.deltaMetrics = null;
        return prevDelta;
    }

    public synchronized SrdiDestinationMeter getSrdiDestinationMeter(EndpointAddress endpointAddress) {
        PeerID peerID = MetricUtilities.getPeerIdFromEndpointAddress(endpointAddress);
        return this.getSrdiDestinationMeter(peerID);
    }

    public synchronized SrdiDestinationMeter getSrdiDestinationMeter(String peer) {
        PeerID peerID = MetricUtilities.getPeerIdFromString(peer);
        return this.getSrdiDestinationMeter(peerID);
    }

    public synchronized SrdiDestinationMeter getSrdiDestinationMeter(PeerID peerID) {
        SrdiDestinationMeter srdiDestinationMeter = (SrdiDestinationMeter)this.srdiDestinationMeters.get(peerID);
        if (srdiDestinationMeter == null) {
            srdiDestinationMeter = new SrdiDestinationMeter(peerID);
            this.srdiDestinationMeters.put(peerID, srdiDestinationMeter);
            this.cumulativeMetrics.addSrdiDestinationMetric(srdiDestinationMeter.getCumulativeMetrics());
        }
        return srdiDestinationMeter;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new SrdiHandlerMetric(this.handlerName);
    }

    public String toString() {
        return "SrdiHandlerMeter(" + this.handlerName + ")";
    }

    public void setRegistered(boolean registered) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.setRegistered(registered);
        this.cumulativeMetrics.setRegistered(registered);
    }

    public void messageProcessed(ResolverSrdiMsg srdi, long processTime, EndpointAddress srcAddr) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.messageProcessed(processTime);
        this.cumulativeMetrics.messageProcessed(processTime);
        SrdiDestinationMeter destinationMeter = this.getSrdiDestinationMeter(srcAddr);
        destinationMeter.messageProcessed();
    }

    public void errorWhileProcessing(EndpointAddress srcAddr) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorWhileProcessing();
        this.cumulativeMetrics.errorWhileProcessing();
        SrdiDestinationMeter destinationMeter = this.getSrdiDestinationMeter(srcAddr);
        destinationMeter.errorWhileProcessing();
    }

    public void srdiToUnregisteredHandler(EndpointAddress srcAddr) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.srdiToUnregisteredHandler();
        this.cumulativeMetrics.srdiToUnregisteredHandler();
        SrdiDestinationMeter destinationMeter = this.getSrdiDestinationMeter(srcAddr);
        destinationMeter.srdiToUnregisteredHandler();
    }

    public void messageSentViaUnicast(String peer, ResolverSrdiMsg srdi) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.messageSentViaUnicast();
        this.cumulativeMetrics.messageSentViaUnicast();
        SrdiDestinationMeter destinationMeter = this.getSrdiDestinationMeter(peer);
        destinationMeter.messageSentViaUnicast();
    }

    public void messageSentViaWalker(ResolverSrdiMsg srdi) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.messageSentViaWalker();
        this.cumulativeMetrics.messageSentViaWalker();
    }

    public void errorSendingMessage() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorSendingMessage();
        this.cumulativeMetrics.errorSendingMessage();
    }

    public void errorPropagatingMessage() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorPropagatingMessage();
        this.cumulativeMetrics.errorPropagatingMessage();
    }
}

